/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.help.ui.internal.search;
import org.eclipse.jface.viewers.*;
import org.eclipse.search.ui.text.*;
public class ResultTableContentProvider implements IStructuredContentProvider {
	protected final Object[] EMPTY_ARRAY = new Object[0];
	private AbstractTextSearchResult searchResult;
	private TableViewer tableViewer;
	public Object[] getElements(Object inputElement) {
		if (inputElement instanceof AbstractTextSearchResult)
			return ((AbstractTextSearchResult) inputElement).getElements();
		return EMPTY_ARRAY;
	}
	public void dispose() {
	}
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		tableViewer = (TableViewer) viewer;
		searchResult = (AbstractTextSearchResult) newInput;
	}
	public void elementsChanged(Object[] updatedElements) {
		for (int i = 0; i < updatedElements.length; i++) {
			if (searchResult.getMatchCount(updatedElements[i]) > 0) {
				if (tableViewer.testFindItem(updatedElements[i]) != null)
					tableViewer.refresh(updatedElements[i]);
				else
					tableViewer.add(updatedElements[i]);
			} else {
				tableViewer.remove(updatedElements[i]);
			}
		}
	}
	public void clear() {
		tableViewer.refresh();
	}
}