/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.internal.ActionSetActionBars;
import org.eclipse.ui.internal.PluginActionSet;
import org.eclipse.ui.internal.PluginActionSetBuilder;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.registry.IActionSet;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;

public class ActionPresentation {
    private WorkbenchWindow window;
    private HashMap mapDescToRec = new HashMap(3);
    private HashMap invisibleBars = new HashMap(3);

    public ActionPresentation(WorkbenchWindow window) {
        this.window = window;
    }

    public void clearActionSets() {
        List oldList = this.copyActionSets(this.mapDescToRec);
        oldList.addAll(this.copyActionSets(this.invisibleBars));
        Iterator iter = oldList.iterator();
        while (iter.hasNext()) {
            IActionSetDescriptor desc = (IActionSetDescriptor)iter.next();
            this.removeActionSet(desc);
        }
    }

    private List copyActionSets(Map map) {
        Set keys = map.keySet();
        ArrayList list = new ArrayList(keys.size());
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public void removeActionSet(IActionSetDescriptor desc) {
        SetRec rec = (SetRec)this.mapDescToRec.get(desc);
        if (rec == null) {
            rec = (SetRec)this.invisibleBars.get(desc);
        }
        if (rec != null) {
            this.mapDescToRec.remove(desc);
            this.invisibleBars.remove(desc);
            IActionSet set = rec.set;
            SubActionBars bars = rec.bars;
            if (bars != null) {
                bars.dispose();
            }
            if (set != null) {
                set.dispose();
            }
        }
    }

    public void setActionSets(IActionSetDescriptor[] newArray) {
        List<IActionSetDescriptor> newList = Arrays.asList(newArray);
        List oldList = this.copyActionSets(this.mapDescToRec);
        Iterator<Object> iter = oldList.iterator();
        while (iter.hasNext()) {
            SetRec rec;
            IActionSetDescriptor desc = (IActionSetDescriptor)iter.next();
            if (newList.contains(desc) || (rec = (SetRec)this.mapDescToRec.get(desc)) == null) continue;
            this.mapDescToRec.remove(desc);
            IActionSet set = rec.set;
            SubActionBars bars = rec.bars;
            if (bars == null) continue;
            SetRec invisibleRec = new SetRec(desc, set, bars);
            this.invisibleBars.put(desc, invisibleRec);
            bars.deactivate();
        }
        iter = newList.iterator();
        ArrayList<IActionSet> sets = new ArrayList<IActionSet>();
        while (iter.hasNext()) {
            IActionSetDescriptor desc = (IActionSetDescriptor)iter.next();
            if (this.mapDescToRec.containsKey(desc)) continue;
            try {
                SetRec rec;
                if (this.invisibleBars.containsKey(desc)) {
                    rec = (SetRec)this.invisibleBars.get(desc);
                    if (rec.bars != null) {
                        rec.bars.activate();
                    }
                    this.invisibleBars.remove(desc);
                } else {
                    IActionSet set = desc.createActionSet();
                    ActionSetActionBars bars = new ActionSetActionBars(this.window.getActionBars(), desc.getId());
                    rec = new SetRec(desc, set, bars);
                    set.init(this.window, bars);
                    sets.add(set);
                }
                this.mapDescToRec.put(desc, rec);
            }
            catch (CoreException e) {
                WorkbenchPlugin.log("Unable to create ActionSet: " + desc.getId());
            }
        }
        PluginActionSetBuilder.processActionSets(sets, this.window);
        iter = sets.iterator();
        while (iter.hasNext()) {
            PluginActionSet set = (PluginActionSet)iter.next();
            set.getBars().activate();
        }
    }

    public IActionSet[] getActionSets() {
        Collection setRecCollection = this.mapDescToRec.values();
        IActionSet[] result = new IActionSet[setRecCollection.size()];
        int i = 0;
        Iterator iterator = setRecCollection.iterator();
        while (iterator.hasNext()) {
            result[i] = ((SetRec)iterator.next()).set;
            ++i;
        }
        return result;
    }

    private class SetRec {
        public IActionSetDescriptor desc;
        public IActionSet set;
        public SubActionBars bars;

        public SetRec(IActionSetDescriptor desc, IActionSet set, SubActionBars bars) {
            this.desc = desc;
            this.set = set;
            this.bars = bars;
        }
    }
}

