/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.adaptor.EclipseAdaptor;
import org.eclipse.core.runtime.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.adaptor.EclipseLog;
import org.eclipse.core.runtime.adaptor.EnvironmentInfo;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.core.runtime.adaptor.Semaphore;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.internal.core.OSGi;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.stats.StatsManager;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.runnable.ParameterizedRunnable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

public class EclipseStarter {
    private static FrameworkAdaptor adaptor;
    private static BundleContext context;
    private static ServiceTracker applicationTracker;
    private static boolean initialize;
    public static boolean debug;
    private static boolean running;
    private static final String CLEAN = "-clean";
    private static final String CONSOLE = "-console";
    private static final String CONSOLE_LOG = "-consoleLog";
    private static final String DEBUG = "-debug";
    private static final String INITIALIZE = "-initialize";
    private static final String DEV = "-dev";
    private static final String WS = "-ws";
    private static final String OS = "-os";
    private static final String ARCH = "-arch";
    private static final String NL = "-nl";
    private static final String CONFIGURATION = "-configuration";
    private static final String USER = "-user";
    private static final String DATA = "-data";
    public static final String PROP_BUNDLES = "osgi.bundles";
    public static final String PROP_BUNDLES_STARTLEVEL = "osgi.bundles.defaultStartLevel";
    public static final String PROP_INITIAL_STARTLEVEL = "osgi.startLevel";
    public static final String PROP_DEBUG = "osgi.debug";
    public static final String PROP_DEV = "osgi.dev";
    public static final String PROP_CLEAN = "osgi.clean";
    public static final String PROP_CONSOLE = "osgi.console";
    public static final String PROP_CONSOLE_CLASS = "osgi.consoleClass";
    public static final String PROP_CHECK_CONFIG = "osgi.checkConfiguration";
    public static final String PROP_OS = "osgi.os";
    public static final String PROP_WS = "osgi.ws";
    public static final String PROP_NL = "osgi.nl";
    public static final String PROP_ARCH = "osgi.arch";
    public static final String PROP_ADAPTOR = "osgi.adaptor";
    public static final String PROP_SYSPATH = "osgi.syspath";
    public static final String PROP_LOGFILE = "osgi.logfile";
    public static final String PROP_EXITCODE = "eclipse.exitcode";
    public static final String PROP_EXITDATA = "eclipse.exitdata";
    public static final String PROP_CONSOLE_LOG = "eclipse.consoleLog";
    private static final String PROP_VM = "eclipse.vm";
    private static final String PROP_VMARGS = "eclipse.vmargs";
    private static final String PROP_COMMANDS = "eclipse.commands";
    private static final String FILE_SCHEME = "file:";
    private static final String FILE_PROTOCOL = "file";
    private static final String REFERENCE_SCHEME = "reference:";
    private static final String REFERENCE_PROTOCOL = "reference";
    private static final String INITIAL_LOCATION = "initial@";
    protected static final String DEFAULT_ADAPTOR_CLASS = "org.eclipse.core.runtime.adaptor.EclipseAdaptor";
    protected static final String DEFAULT_CONSOLE_CLASS = "org.eclipse.osgi.framework.internal.core.FrameworkConsole";
    private static final String CONSOLE_NAME = "OSGi Console";
    private static FrameworkLog log;
    static /* synthetic */ Class class$java$lang$Runnable;
    static /* synthetic */ Class class$org$osgi$service$packageadmin$PackageAdmin;
    static /* synthetic */ Class class$org$eclipse$osgi$framework$internal$core$OSGi;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$org$eclipse$core$runtime$adaptor$EclipseStarter;
    static /* synthetic */ Class class$org$osgi$service$startlevel$StartLevel;
    static /* synthetic */ Class class$org$eclipse$osgi$service$runnable$ParameterizedRunnable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Object run(String[] args, Runnable endSplashHandler) throws Exception {
        block16: {
            Object object;
            boolean startupFailed;
            block15: {
                if (running) {
                    throw new IllegalStateException(EclipseAdaptorMsg.formatter.getString("ECLIPSE_STARTUP_ALREADY_RUNNING"));
                }
                startupFailed = true;
                EclipseStarter.startup(args, endSplashHandler);
                startupFailed = false;
                object = EclipseStarter.run(null);
                Object var6_5 = null;
                try {
                    EclipseStarter.shutdown();
                }
                catch (Throwable e2) {
                    FrameworkLogEntry logEntry = new FrameworkLogEntry("org.eclipse.osgi", EclipseAdaptorMsg.formatter.getString("ECLIPSE_STARTUP_SHUTDOWN_ERROR"), 1, e2, null);
                    if (log != null) {
                        log.log(logEntry);
                        break block15;
                    }
                    e2.printStackTrace();
                }
            }
            return object;
            catch (Throwable e) {
                try {
                    if (endSplashHandler != null) {
                        endSplashHandler.run();
                    }
                    FrameworkLogEntry logEntry = new FrameworkLogEntry("org.eclipse.osgi", startupFailed ? EclipseAdaptorMsg.formatter.getString("ECLIPSE_STARTUP_STARTUP_ERROR") : EclipseAdaptorMsg.formatter.getString("ECLIPSE_STARTUP_APP_ERROR"), 1, e, null);
                    if (log != null) {
                        log.log(logEntry);
                        EclipseStarter.logUnresolvedBundles(context.getBundles());
                    } else {
                        e.printStackTrace();
                    }
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    block17: {
                        Object var6_7 = null;
                        try {
                            EclipseStarter.shutdown();
                        }
                        catch (Throwable e2) {
                            FrameworkLogEntry logEntry = new FrameworkLogEntry("org.eclipse.osgi", EclipseAdaptorMsg.formatter.getString("ECLIPSE_STARTUP_SHUTDOWN_ERROR"), 1, e2, null);
                            if (log != null) {
                                log.log(logEntry);
                                break block17;
                            }
                            e2.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                try {
                    EclipseStarter.shutdown();
                }
                catch (Throwable e2) {
                    FrameworkLogEntry logEntry = new FrameworkLogEntry("org.eclipse.osgi", EclipseAdaptorMsg.formatter.getString("ECLIPSE_STARTUP_SHUTDOWN_ERROR"), 1, e2, null);
                    if (log != null) {
                        log.log(logEntry);
                        break block16;
                    }
                    e2.printStackTrace();
                }
            }
        }
        System.getProperties().put(PROP_EXITCODE, "13");
        System.getProperties().put(PROP_EXITDATA, EclipseAdaptorMsg.formatter.getString("ECLIPSE_STARTUP_ERROR_CHECK_LOG", (Object)log.getFile().getPath()));
        return null;
    }

    public static boolean isRunning() {
        return running;
    }

    protected static FrameworkLog createFrameworkLog() {
        EclipseLog frameworkLog;
        String logFileProp = System.getProperty(PROP_LOGFILE);
        if (logFileProp != null) {
            frameworkLog = new EclipseLog(new File(logFileProp));
        } else {
            Location location = LocationManager.getConfigurationLocation();
            File configAreaDirectory = null;
            if (location != null) {
                configAreaDirectory = new File(location.getURL().getFile());
            }
            if (configAreaDirectory != null) {
                String logFileName = Long.toString(System.currentTimeMillis()) + ".log";
                File logFile = new File(configAreaDirectory, logFileName);
                System.getProperties().put(PROP_LOGFILE, logFile.getAbsolutePath());
                frameworkLog = new EclipseLog(logFile);
            } else {
                frameworkLog = new EclipseLog();
            }
        }
        if ("true".equals(System.getProperty(PROP_CONSOLE_LOG))) {
            frameworkLog.setConsoleLog(true);
        }
        return frameworkLog;
    }

    public static void startup(String[] args, Runnable endSplashHandler) throws Exception {
        if (running) {
            throw new IllegalStateException(EclipseAdaptorMsg.formatter.getString("ECLIPSE_STARTUP_ALREADY_RUNNING"));
        }
        long start = 0L;
        EclipseStarter.processCommandLine(args);
        LocationManager.initializeLocations();
        log = EclipseStarter.createFrameworkLog();
        EclipseStarter.loadConfigurationInfo();
        EclipseStarter.loadDefaultProperties();
        EclipseStarter.finalizeProperties();
        adaptor = EclipseStarter.createAdaptor();
        ((EclipseAdaptor)adaptor).setLog(log);
        OSGi osgi = new OSGi(adaptor);
        osgi.launch();
        String console = System.getProperty(PROP_CONSOLE);
        if (console != null) {
            EclipseStarter.startConsole(osgi, new String[0], console);
        }
        context = osgi.getBundleContext();
        EclipseStarter.publishSplashScreen(endSplashHandler);
        Bundle[] startBundles = EclipseStarter.loadBasicBundles();
        EclipseStarter.setStartLevel(EclipseStarter.getStartLevel());
        EclipseStarter.ensureBundlesActive(startBundles);
        if (debug) {
            EclipseStarter.logUnresolvedBundles(context.getBundles());
        }
        running = true;
    }

    private static int getStartLevel() {
        block3: {
            String level = System.getProperty(PROP_INITIAL_STARTLEVEL);
            if (level != null) {
                try {
                    return Integer.parseInt(level);
                }
                catch (NumberFormatException e) {
                    if (!debug) break block3;
                    System.out.println("Start level = " + level + "  parsed. Using hardcoded default: 6");
                }
            }
        }
        return 6;
    }

    public static Object run(Object argument) throws Exception {
        if (!running) {
            throw new IllegalStateException(EclipseAdaptorMsg.formatter.getString("ECLIPSE_STARTUP_NOT_RUNNING"));
        }
        if (initialize) {
            return new Integer(0);
        }
        EclipseStarter.initializeApplicationTracker();
        ParameterizedRunnable application = (ParameterizedRunnable)applicationTracker.getService();
        applicationTracker.close();
        if (application == null) {
            throw new IllegalStateException(EclipseAdaptorMsg.formatter.getString("ECLIPSE_STARTUP_ERROR_NO_APPLICATION"));
        }
        if (debug) {
            String timeString = System.getProperty("eclipse.startTime");
            long time = timeString == null ? 0L : Long.parseLong(timeString);
            System.out.println("Starting application: " + (System.currentTimeMillis() - time));
        }
        return application.run(argument);
    }

    public static void shutdown() throws Exception {
        if (!running) {
            return;
        }
        EclipseStarter.stopSystemBundle();
    }

    private static void ensureBundlesActive(Bundle[] bundles) {
        for (int i = 0; i < bundles.length; ++i) {
            if (bundles[i].getState() == 32) continue;
            String message = EclipseAdaptorMsg.formatter.getString("ECLIPSE_STARTUP_ERROR_BUNDLE_NOT_ACTIVE", (Object)bundles[i]);
            throw new IllegalStateException(message);
        }
    }

    private static void logUnresolvedBundles(Bundle[] bundles) {
        State state = adaptor.getState();
        FrameworkLog logService = adaptor.getFrameworkLog();
        StateHelper stateHelper = adaptor.getPlatformAdmin().getStateHelper();
        for (int i = 0; i < bundles.length; ++i) {
            if (bundles[i].getState() != 2) continue;
            String generalMessage = EclipseAdaptorMsg.formatter.getString("ECLIPSE_STARTUP_ERROR_BUNDLE_NOT_RESOLVED", (Object)bundles[i]);
            BundleDescription description = state.getBundle(bundles[i].getBundleId());
            if (description == null) continue;
            FrameworkLogEntry[] logChildren = null;
            VersionConstraint[] unsatisfied = stateHelper.getUnsatisfiedConstraints(description);
            if (unsatisfied.length > 0) {
                logChildren = new FrameworkLogEntry[unsatisfied.length];
                for (int j = 0; j < unsatisfied.length; ++j) {
                    logChildren[j] = new FrameworkLogEntry("org.eclipse.osgi", EclipseAdaptorMsg.getResolutionFailureMessage(unsatisfied[j]), 0, null, null);
                }
            } else if (description.getSymbolicName() != null) {
                BundleDescription[] homonyms = state.getBundles(description.getSymbolicName());
                for (int j = 0; j < homonyms.length; ++j) {
                    if (!homonyms[j].isResolved()) continue;
                    logChildren = new FrameworkLogEntry[]{new FrameworkLogEntry("org.eclipse.osgi", EclipseAdaptorMsg.formatter.getString("ECLIPSE_CONSOLE_OTHER_VERSION", (Object)homonyms[j].getLocation()), 0, null, null)};
                }
            }
            logService.log(new FrameworkLogEntry("org.eclipse.osgi", generalMessage, 0, null, logChildren));
        }
    }

    private static void publishSplashScreen(final Runnable endSplashHandler) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("name", "splashscreen");
        Runnable handler = new Runnable(){

            public void run() {
                StatsManager.doneBooting();
                endSplashHandler.run();
            }
        };
        context.registerService((class$java$lang$Runnable == null ? (class$java$lang$Runnable = EclipseStarter.class$("java.lang.Runnable")) : class$java$lang$Runnable).getName(), (Object)handler, properties);
    }

    private static URL searchForBundle(String name, String parent) throws MalformedURLException {
        Object result;
        URL url = null;
        File fileLocation = null;
        boolean reference = false;
        try {
            URL child = new URL(name);
            url = new URL(new File(parent).toURL(), name);
        }
        catch (MalformedURLException e) {
            File child = new File(name);
            fileLocation = child.isAbsolute() ? child : new File(parent, name);
            url = new URL(REFERENCE_PROTOCOL, null, fileLocation.toURL().toExternalForm());
            reference = true;
        }
        if (!reference) {
            URL baseURL = url;
            if (url.getProtocol().equals(REFERENCE_PROTOCOL)) {
                File child;
                reference = true;
                String baseSpec = url.getFile();
                baseURL = baseSpec.startsWith(FILE_SCHEME) ? ((child = new File(baseSpec.substring(5))).isAbsolute() ? child.toURL() : new File(parent, child.getPath()).toURL()) : new URL(baseSpec);
            }
            if (!(fileLocation = new File(baseURL.getFile())).isAbsolute()) {
                fileLocation = new File(parent, fileLocation.toString());
            }
        }
        if (reference) {
            result = EclipseStarter.searchFor(fileLocation.getName(), new File(fileLocation.getParent()).getAbsolutePath());
            if (result != null) {
                url = new URL(REFERENCE_PROTOCOL, null, FILE_SCHEME + (String)result);
            } else {
                return null;
            }
        }
        try {
            result = url.openConnection();
            ((URLConnection)result).connect();
            return url;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static Bundle[] loadBasicBundles() throws IOException {
        long startTime = System.currentTimeMillis();
        String[] installEntries = EclipseStarter.getArrayFromList(System.getProperty(PROP_BUNDLES), ",");
        InitialBundle[] initialBundles = EclipseStarter.getInitialBundles(installEntries);
        Bundle[] curInitBundles = EclipseStarter.getCurrentInitialBundles();
        boolean refresh = EclipseStarter.uninstallBundles(curInitBundles, initialBundles);
        ArrayList startBundles = new ArrayList(installEntries.length);
        ArrayList newInitBundles = new ArrayList(installEntries.length);
        if (refresh |= EclipseStarter.installBundles(initialBundles, curInitBundles, startBundles, newInitBundles)) {
            Bundle[] installedBundles = newInitBundles.toArray(new Bundle[newInitBundles.size()]);
            EclipseStarter.refreshPackages(installedBundles);
        }
        Bundle[] startInitBundles = startBundles.toArray(new Bundle[startBundles.size()]);
        EclipseStarter.startBundles(startInitBundles);
        if (debug) {
            System.out.println("Time to load bundles: " + (System.currentTimeMillis() - startTime));
        }
        return startInitBundles;
    }

    private static InitialBundle[] getInitialBundles(String[] installEntries) throws MalformedURLException {
        ArrayList<InitialBundle> result = new ArrayList<InitialBundle>(installEntries.length);
        int defaultStartLevel = Integer.parseInt(System.getProperty(PROP_BUNDLES_STARTLEVEL));
        String syspath = EclipseStarter.getSysPath();
        for (int i = 0; i < installEntries.length; ++i) {
            URL location;
            String name = installEntries[i];
            int level = defaultStartLevel;
            boolean start = false;
            int index = name.indexOf(64);
            if (index >= 0) {
                String[] attributes = EclipseStarter.getArrayFromList(name.substring(index + 1, name.length()), ":");
                name = name.substring(0, index);
                for (int j = 0; j < attributes.length; ++j) {
                    String attribute = attributes[j];
                    if (attribute.equals("start")) {
                        start = true;
                        continue;
                    }
                    level = Integer.parseInt(attribute);
                }
            }
            if ((location = EclipseStarter.searchForBundle(name, syspath)) == null) {
                FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", EclipseAdaptorMsg.formatter.getString("ECLIPSE_STARTUP_BUNDLE_NOT_FOUND", (Object)installEntries[i]), 0, null, null);
                log.log(entry);
                continue;
            }
            String locationString = INITIAL_LOCATION + location.toExternalForm();
            result.add(new InitialBundle(locationString, location, level, start));
        }
        return result.toArray(new InitialBundle[result.size()]);
    }

    private static void refreshPackages(Bundle[] bundles) {
        if (bundles.length == 0) {
            return;
        }
        ServiceReference packageAdminRef = context.getServiceReference((class$org$osgi$service$packageadmin$PackageAdmin == null ? (class$org$osgi$service$packageadmin$PackageAdmin = EclipseStarter.class$("org.osgi.service.packageadmin.PackageAdmin")) : class$org$osgi$service$packageadmin$PackageAdmin).getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminRef != null && (packageAdmin = (PackageAdmin)context.getService(packageAdminRef)) == null) {
            return;
        }
        final Semaphore semaphore = new Semaphore(0);
        FrameworkListener listener = new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() == 4) {
                    semaphore.release();
                }
            }
        };
        context.addFrameworkListener(listener);
        packageAdmin.refreshPackages(bundles);
        semaphore.acquire();
        context.removeFrameworkListener(listener);
        context.ungetService(packageAdminRef);
    }

    private static void startConsole(OSGi osgi, String[] consoleArgs, String consolePort) {
        try {
            Object[] parameters;
            Class[] parameterTypes;
            String consoleClassName = System.getProperty(PROP_CONSOLE_CLASS, DEFAULT_CONSOLE_CLASS);
            Class<?> consoleClass = Class.forName(consoleClassName);
            if (consolePort.length() == 0) {
                parameterTypes = new Class[]{class$org$eclipse$osgi$framework$internal$core$OSGi == null ? (class$org$eclipse$osgi$framework$internal$core$OSGi = EclipseStarter.class$("org.eclipse.osgi.framework.internal.core.OSGi")) : class$org$eclipse$osgi$framework$internal$core$OSGi, array$Ljava$lang$String == null ? (array$Ljava$lang$String = EclipseStarter.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
                parameters = new Object[]{osgi, consoleArgs};
            } else {
                parameterTypes = new Class[]{class$org$eclipse$osgi$framework$internal$core$OSGi == null ? (class$org$eclipse$osgi$framework$internal$core$OSGi = EclipseStarter.class$("org.eclipse.osgi.framework.internal.core.OSGi")) : class$org$eclipse$osgi$framework$internal$core$OSGi, Integer.TYPE, array$Ljava$lang$String == null ? (array$Ljava$lang$String = EclipseStarter.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
                parameters = new Object[]{osgi, new Integer(consolePort), consoleArgs};
            }
            Constructor<?> constructor = consoleClass.getConstructor(parameterTypes);
            Object console = constructor.newInstance(parameters);
            Thread t = new Thread((Runnable)console, CONSOLE_NAME);
            t.start();
        }
        catch (NumberFormatException nfe) {
            System.err.println(EclipseAdaptorMsg.formatter.getString("ECLIPSE_STARTUP_INVALID_PORT", (Object)consolePort));
        }
        catch (Exception ex) {
            System.out.println(EclipseAdaptorMsg.formatter.getString("ECLIPSE_STARTUP_FAILED_FIND", (Object)CONSOLE_NAME));
        }
    }

    private static FrameworkAdaptor createAdaptor() throws Exception {
        String adaptorClassName = System.getProperty(PROP_ADAPTOR, DEFAULT_ADAPTOR_CLASS);
        Class<?> adaptorClass = Class.forName(adaptorClassName);
        Class[] constructorArgs = new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = EclipseStarter.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
        Constructor<?> constructor = adaptorClass.getConstructor(constructorArgs);
        return (FrameworkAdaptor)constructor.newInstance(new Object[]{new String[0]});
    }

    private static String[] processCommandLine(String[] args) throws Exception {
        EnvironmentInfo.allArgs = args;
        if (args.length == 0) {
            EnvironmentInfo.frameworkArgs = args;
            EnvironmentInfo.appArgs = args;
            return args;
        }
        int[] configArgs = new int[args.length];
        configArgs[0] = -1;
        int configArgIndex = 0;
        for (int i = 0; i < args.length; ++i) {
            boolean found = false;
            if (args[i].equalsIgnoreCase(DEBUG) && (i + 1 == args.length || i + 1 < args.length && args[i + 1].startsWith("-"))) {
                System.getProperties().put(PROP_DEBUG, "");
                debug = true;
                found = true;
            }
            if (args[i].equalsIgnoreCase(DEV) && (i + 1 == args.length || i + 1 < args.length && args[i + 1].startsWith("-"))) {
                System.getProperties().put(PROP_DEV, "");
                found = true;
            }
            if (args[i].equalsIgnoreCase(INITIALIZE)) {
                initialize = true;
                found = true;
            }
            if (args[i].equalsIgnoreCase(CLEAN)) {
                System.getProperties().put(PROP_CLEAN, "true");
                found = true;
            }
            if (args[i].equalsIgnoreCase(CONSOLE_LOG)) {
                System.getProperties().put(PROP_CONSOLE_LOG, "true");
                found = true;
            }
            if (args[i].equalsIgnoreCase(CONSOLE) && (i + 1 == args.length || i + 1 < args.length && args[i + 1].startsWith("-"))) {
                System.getProperties().put(PROP_CONSOLE, "");
                found = true;
            }
            if (found) {
                configArgs[configArgIndex++] = i;
                continue;
            }
            if (i == args.length - 1 || args[i + 1].startsWith("-")) continue;
            String arg = args[++i];
            if (args[i - 1].equalsIgnoreCase(CONSOLE)) {
                System.getProperties().put(PROP_CONSOLE, arg);
                found = true;
            }
            if (args[i - 1].equalsIgnoreCase(CONFIGURATION)) {
                System.getProperties().put("osgi.configuration.area", arg);
                found = true;
            }
            if (args[i - 1].equalsIgnoreCase(DATA)) {
                System.getProperties().put("osgi.instance.area", arg);
                found = true;
            }
            if (args[i - 1].equalsIgnoreCase(USER)) {
                System.getProperties().put("osgi.user.area", arg);
                found = true;
            }
            if (args[i - 1].equalsIgnoreCase(DEV)) {
                System.getProperties().put(PROP_DEV, arg);
                found = true;
            }
            if (args[i - 1].equalsIgnoreCase(DEBUG)) {
                System.getProperties().put(PROP_DEBUG, arg);
                debug = true;
                found = true;
            }
            if (args[i - 1].equalsIgnoreCase(WS)) {
                System.getProperties().put(PROP_WS, arg);
                found = true;
            }
            if (args[i - 1].equalsIgnoreCase(OS)) {
                System.getProperties().put(PROP_OS, arg);
                found = true;
            }
            if (args[i - 1].equalsIgnoreCase(ARCH)) {
                System.getProperties().put(PROP_ARCH, arg);
                found = true;
            }
            if (args[i - 1].equalsIgnoreCase(NL)) {
                System.getProperties().put(PROP_NL, arg);
                found = true;
            }
            if (!found) continue;
            configArgs[configArgIndex++] = i - 1;
            configArgs[configArgIndex++] = i;
        }
        if (configArgIndex == 0) {
            EnvironmentInfo.frameworkArgs = new String[0];
            EnvironmentInfo.appArgs = args;
            return args;
        }
        EnvironmentInfo.appArgs = new String[args.length - configArgIndex];
        EnvironmentInfo.frameworkArgs = new String[configArgIndex];
        configArgIndex = 0;
        int j = 0;
        int k = 0;
        for (int i = 0; i < args.length; ++i) {
            if (i == configArgs[configArgIndex]) {
                EnvironmentInfo.frameworkArgs[k++] = args[i];
                ++configArgIndex;
                continue;
            }
            EnvironmentInfo.appArgs[j++] = args[i];
        }
        return EnvironmentInfo.appArgs;
    }

    private static String[] getArrayFromList(String prop, String separator) {
        if (prop == null || prop.trim().equals("")) {
            return new String[0];
        }
        Vector<String> list = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(prop, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.addElement(token);
        }
        return list.isEmpty() ? new String[]{} : list.toArray(new String[list.size()]);
    }

    protected static String getSysPath() {
        String result = System.getProperty(PROP_SYSPATH);
        if (result != null) {
            return result;
        }
        URL url = (class$org$eclipse$core$runtime$adaptor$EclipseStarter == null ? (class$org$eclipse$core$runtime$adaptor$EclipseStarter = EclipseStarter.class$("org.eclipse.core.runtime.adaptor.EclipseStarter")) : class$org$eclipse$core$runtime$adaptor$EclipseStarter).getProtectionDomain().getCodeSource().getLocation();
        result = url.getFile();
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        result = result.substring(0, result.lastIndexOf(47));
        if (Character.isUpperCase((result = result.substring(0, result.lastIndexOf(47))).charAt(0))) {
            char[] chars = result.toCharArray();
            chars[0] = Character.toLowerCase(chars[0]);
            result = new String(chars);
        }
        return result;
    }

    private static Bundle[] getCurrentInitialBundles() {
        Bundle[] installed = context.getBundles();
        ArrayList<Bundle> initial = new ArrayList<Bundle>();
        for (int i = 0; i < installed.length; ++i) {
            Bundle bundle = installed[i];
            if (!bundle.getLocation().startsWith(INITIAL_LOCATION)) continue;
            initial.add(bundle);
        }
        return initial.toArray(new Bundle[initial.size()]);
    }

    private static Bundle getBundleByLocation(String location, Bundle[] bundles) {
        for (int i = 0; i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            if (!location.equalsIgnoreCase(bundle.getLocation())) continue;
            return bundle;
        }
        return null;
    }

    private static boolean uninstallBundles(Bundle[] curInitBundles, InitialBundle[] newInitBundles) {
        boolean uninstalledBundle = false;
        for (int i = 0; i < curInitBundles.length; ++i) {
            boolean found = false;
            for (int j = 0; j < newInitBundles.length; ++j) {
                if (!curInitBundles[i].getLocation().equalsIgnoreCase(newInitBundles[j].locationString)) continue;
                found = true;
                break;
            }
            if (found) continue;
            try {
                curInitBundles[i].uninstall();
                uninstalledBundle = true;
                continue;
            }
            catch (BundleException e) {
                FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", EclipseAdaptorMsg.formatter.getString("ECLIPSE_STARTUP_FAILED_UNINSTALL", (Object)curInitBundles[i].getLocation()), 0, (Throwable)e, null);
                log.log(entry);
            }
        }
        return uninstalledBundle;
    }

    private static boolean installBundles(InitialBundle[] initialBundles, Bundle[] curInitBundles, ArrayList startBundles, ArrayList newInitBundles) {
        boolean installed = false;
        ServiceReference reference = context.getServiceReference((class$org$osgi$service$startlevel$StartLevel == null ? (class$org$osgi$service$startlevel$StartLevel = EclipseStarter.class$("org.osgi.service.startlevel.StartLevel")) : class$org$osgi$service$startlevel$StartLevel).getName());
        StartLevel startService = null;
        if (reference != null) {
            startService = (StartLevel)context.getService(reference);
        }
        for (int i = 0; i < initialBundles.length; ++i) {
            FrameworkLogEntry entry;
            Bundle osgiBundle = EclipseStarter.getBundleByLocation(initialBundles[i].locationString, curInitBundles);
            try {
                if (osgiBundle == null) {
                    InputStream in = initialBundles[i].location.openStream();
                    osgiBundle = context.installBundle(initialBundles[i].locationString, in);
                    installed = true;
                    if (initialBundles[i].level >= 0 && startService != null) {
                        startService.setBundleStartLevel(osgiBundle, initialBundles[i].level);
                    }
                }
                if (initialBundles[i].start) {
                    startBundles.add(osgiBundle);
                }
                newInitBundles.add(osgiBundle);
                continue;
            }
            catch (BundleException e) {
                entry = new FrameworkLogEntry("org.eclipse.osgi", EclipseAdaptorMsg.formatter.getString("ECLIPSE_STARTUP_FAILED_INSTALL", (Object)initialBundles[i].location), 0, (Throwable)e, null);
                log.log(entry);
                continue;
            }
            catch (IOException e) {
                entry = new FrameworkLogEntry("org.eclipse.osgi", EclipseAdaptorMsg.formatter.getString("ECLIPSE_STARTUP_FAILED_INSTALL", (Object)initialBundles[i].location), 0, (Throwable)e, null);
                log.log(entry);
            }
        }
        context.ungetService(reference);
        return installed;
    }

    private static void startBundles(Bundle[] bundles) {
        for (int i = 0; i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            if (bundle.getState() == 2) {
                throw new IllegalStateException(EclipseAdaptorMsg.formatter.getString("ECLIPSE_STARTUP_ERROR_BUNDLE_NOT_RESOLVED", (Object)bundle.getLocation()));
            }
            try {
                bundle.start();
                continue;
            }
            catch (BundleException e) {
                FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", EclipseAdaptorMsg.formatter.getString("ECLIPSE_STARTUP_FAILED_START", (Object)bundle.getLocation()), 0, (Throwable)e, null);
                log.log(entry);
            }
        }
    }

    private static void initializeApplicationTracker() {
        Filter filter = null;
        try {
            String appClass = (class$org$eclipse$osgi$service$runnable$ParameterizedRunnable == null ? (class$org$eclipse$osgi$service$runnable$ParameterizedRunnable = EclipseStarter.class$("org.eclipse.osgi.service.runnable.ParameterizedRunnable")) : class$org$eclipse$osgi$service$runnable$ParameterizedRunnable).getName();
            filter = context.createFilter("(&(objectClass=" + appClass + ")(eclipse.application=*))");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        applicationTracker = new ServiceTracker(context, filter, null);
        applicationTracker.open();
    }

    private static void loadConfigurationInfo() {
        Location configArea = LocationManager.getConfigurationLocation();
        if (configArea == null) {
            return;
        }
        URL location = null;
        try {
            location = new URL(configArea.getURL().toExternalForm() + "config.ini");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        EclipseStarter.mergeProperties(System.getProperties(), EclipseStarter.loadProperties(location));
    }

    private static void loadDefaultProperties() {
        URL codeLocation = (class$org$eclipse$core$runtime$adaptor$EclipseStarter == null ? (class$org$eclipse$core$runtime$adaptor$EclipseStarter = EclipseStarter.class$("org.eclipse.core.runtime.adaptor.EclipseStarter")) : class$org$eclipse$core$runtime$adaptor$EclipseStarter).getProtectionDomain().getCodeSource().getLocation();
        if (codeLocation == null) {
            return;
        }
        String location = codeLocation.getFile();
        if (location.endsWith("/")) {
            location = location.substring(0, location.length() - 1);
        }
        int i = location.lastIndexOf(47);
        location = location.substring(0, i + 1) + "eclipse.properties";
        URL result = null;
        try {
            result = new File(location).toURL();
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        EclipseStarter.mergeProperties(System.getProperties(), EclipseStarter.loadProperties(result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(URL location) {
        Properties result = new Properties();
        if (location == null) {
            return result;
        }
        try {
            InputStream in = location.openStream();
            try {
                result.load(in);
            }
            finally {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static void mergeProperties(Properties destination, Properties source) {
        Enumeration<Object> e = source.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = source.getProperty(key);
            if (destination.getProperty(key) != null) continue;
            destination.put(key, value);
        }
    }

    private static void stopSystemBundle() throws BundleException {
        if (context == null || !running) {
            return;
        }
        Bundle systemBundle = context.getBundle(0L);
        if (systemBundle.getState() == 32) {
            final Semaphore semaphore = new Semaphore(0);
            FrameworkListener listener = new FrameworkListener(){

                public void frameworkEvent(FrameworkEvent event) {
                    if (event.getType() == 8) {
                        semaphore.release();
                    }
                }
            };
            context.addFrameworkListener(listener);
            systemBundle.stop();
            semaphore.acquire();
            context.removeFrameworkListener(listener);
        }
        context = null;
        applicationTracker = null;
        running = false;
    }

    private static void setStartLevel(final int value) {
        ServiceTracker tracker = new ServiceTracker(context, (class$org$osgi$service$startlevel$StartLevel == null ? (class$org$osgi$service$startlevel$StartLevel = EclipseStarter.class$("org.osgi.service.startlevel.StartLevel")) : class$org$osgi$service$startlevel$StartLevel).getName(), null);
        tracker.open();
        final StartLevel startLevel = (StartLevel)tracker.getService();
        final Semaphore semaphore = new Semaphore(0);
        FrameworkListener listener = new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() == 8 && startLevel.getStartLevel() == value) {
                    semaphore.release();
                }
            }
        };
        context.addFrameworkListener(listener);
        startLevel.setStartLevel(value);
        semaphore.acquire();
        context.removeFrameworkListener(listener);
        tracker.close();
    }

    private static String searchFor(String target, String start) {
        String[] candidates = new File(start).list();
        if (candidates == null) {
            return null;
        }
        String result = null;
        Object[] maxVersion = null;
        for (int i = 0; i < candidates.length; ++i) {
            File candidate = new File(start, candidates[i]);
            if (!candidate.getName().equals(target) && !candidate.getName().startsWith(target + "_")) continue;
            String name = candidate.getName();
            String version = "";
            int index = name.indexOf(95);
            if (index != -1) {
                version = name.substring(index + 1);
            }
            Object[] currentVersion = EclipseStarter.getVersionElements(version);
            if (maxVersion == null) {
                result = candidate.getAbsolutePath();
                maxVersion = currentVersion;
                continue;
            }
            if (EclipseStarter.compareVersion(maxVersion, currentVersion) >= 0) continue;
            result = candidate.getAbsolutePath();
            maxVersion = currentVersion;
        }
        if (result == null) {
            return null;
        }
        return result.replace(File.separatorChar, '/') + "/";
    }

    private static Object[] getVersionElements(String version) {
        Object[] result = new Object[]{new Integer(0), new Integer(0), new Integer(0), ""};
        StringTokenizer t = new StringTokenizer(version, ".");
        int i = 0;
        while (t.hasMoreTokens() && i < 4) {
            String token = t.nextToken();
            if (i < 3) {
                try {
                    result[i++] = new Integer(token);
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
            result[i++] = token;
        }
        return result;
    }

    private static int compareVersion(Object[] left, Object[] right) {
        int result = ((Integer)left[0]).compareTo((Integer)right[0]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[1]).compareTo((Integer)right[1]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[2]).compareTo((Integer)right[2]);
        if (result != 0) {
            return result;
        }
        return ((String)left[3]).compareTo((String)right[3]);
    }

    private static String buildCommandLine(String arg, String value) {
        String commandLine;
        int i;
        StringBuffer result = new StringBuffer(300);
        String entry = System.getProperty(PROP_VM);
        if (entry == null) {
            return null;
        }
        result.append(entry);
        result.append('\n');
        entry = System.getProperty(PROP_VMARGS);
        if (entry != null) {
            result.append(entry);
        }
        if ((entry = System.getProperty(PROP_COMMANDS)) != null) {
            result.append(entry);
        }
        if ((i = (commandLine = result.toString()).indexOf(arg + "\n")) == 0) {
            commandLine = commandLine + arg + "\n" + value + "\n";
        } else {
            String left = commandLine.substring(0, i += arg.length() + 1);
            int j = commandLine.indexOf(10, i);
            String right = commandLine.substring(j);
            commandLine = left + value + right;
        }
        return commandLine;
    }

    private static void finalizeProperties() {
        if (System.getProperty(PROP_DEV) != null && System.getProperty(PROP_CHECK_CONFIG) == null) {
            System.getProperties().put(PROP_CHECK_CONFIG, "true");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        initialize = false;
        debug = false;
        running = false;
    }

    private static class InitialBundle {
        public final String locationString;
        public final URL location;
        public final int level;
        public final boolean start;

        InitialBundle(String locationString, URL location, int level, boolean start) {
            this.locationString = locationString;
            this.location = location;
            this.level = level;
            this.start = start;
        }
    }
}

