/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.plugins;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.core.internal.plugins.DevClassPathHelper;
import org.eclipse.core.internal.plugins.PluginDescriptor;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class PluginClassLoader
extends URLClassLoader {
    private Bundle bundle;
    private PluginDescriptor descriptor;

    PluginClassLoader(PluginDescriptor descriptor) {
        super(PluginClassLoader.computeURLs(descriptor));
        this.descriptor = descriptor;
        this.bundle = InternalPlatform.getDefault().getBundle(descriptor.getUniqueIdentifier());
        if (this.bundle == null) {
            throw new IllegalArgumentException();
        }
    }

    private static URL[] computeURLs(PluginDescriptor descriptor) {
        int i;
        Bundle bundle = InternalPlatform.getDefault().getBundle(descriptor.getUniqueIdentifier());
        if (bundle == null) {
            throw new IllegalArgumentException();
        }
        ILibrary[] libs = descriptor.getRuntimeLibraries();
        String[] devPath = PluginClassLoader.computeDevPath(bundle);
        URL pluginBase = descriptor.getInstallURL();
        try {
            pluginBase = Platform.resolve((URL)descriptor.getInstallURL());
        }
        catch (IOException e1) {
            // empty catch block
        }
        URL[] urls = new URL[devPath.length + libs.length];
        int j = 0;
        for (i = 0; i < devPath.length; ++i) {
            try {
                urls[j++] = new URL(pluginBase, devPath[i]);
                continue;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        for (i = 0; i < libs.length; ++i) {
            try {
                urls[j++] = new URL(pluginBase, libs[i].getPath().toOSString());
                continue;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return urls;
    }

    private static String[] computeDevPath(Bundle bundle) {
        if (!DevClassPathHelper.inDevelopmentMode()) {
            return new String[0];
        }
        String pluginId = bundle.getSymbolicName();
        if (pluginId == null) {
            return new String[0];
        }
        return DevClassPathHelper.getDevClassPath(pluginId);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        return this.bundle.loadClass(name);
    }

    public URL findResource(String name) {
        return this.bundle.getResource(name);
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.descriptor;
    }
}

