/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.Map;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.codeassist.impl.AssistOptions;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.core.INamingRequestor;

public class InternalNamingConventions {
    private static final char[] DEFAULT_NAME = "name".toCharArray();

    private static Scanner getNameScanner(CompilerOptions compilerOptions) {
        return new Scanner(false, false, false, compilerOptions.sourceLevel, null, null, true);
    }

    public static void suggestArgumentNames(IJavaProject javaProject, char[] packageName, char[] qualifiedTypeName, int dim, char[][] excludedNames, INamingRequestor requestor) {
        Map options = javaProject.getOptions(true);
        CompilerOptions compilerOptions = new CompilerOptions(options);
        AssistOptions assistOptions = new AssistOptions(options);
        InternalNamingConventions.suggestNames(packageName, qualifiedTypeName, dim, assistOptions.argumentPrefixes, assistOptions.argumentSuffixes, excludedNames, InternalNamingConventions.getNameScanner(compilerOptions), requestor);
    }

    public static void suggestFieldNames(IJavaProject javaProject, char[] packageName, char[] qualifiedTypeName, int dim, int modifiers, char[][] excludedNames, INamingRequestor requestor) {
        boolean isStatic = Flags.isStatic(modifiers);
        Map options = javaProject.getOptions(true);
        CompilerOptions compilerOptions = new CompilerOptions(options);
        AssistOptions assistOptions = new AssistOptions(options);
        InternalNamingConventions.suggestNames(packageName, qualifiedTypeName, dim, isStatic ? assistOptions.staticFieldPrefixes : assistOptions.fieldPrefixes, isStatic ? assistOptions.staticFieldSuffixes : assistOptions.fieldSuffixes, excludedNames, InternalNamingConventions.getNameScanner(compilerOptions), requestor);
    }

    public static void suggestLocalVariableNames(IJavaProject javaProject, char[] packageName, char[] qualifiedTypeName, int dim, char[][] excludedNames, INamingRequestor requestor) {
        Map options = javaProject.getOptions(true);
        CompilerOptions compilerOptions = new CompilerOptions(options);
        AssistOptions assistOptions = new AssistOptions(options);
        InternalNamingConventions.suggestNames(packageName, qualifiedTypeName, dim, assistOptions.localPrefixes, assistOptions.localSuffixes, excludedNames, InternalNamingConventions.getNameScanner(compilerOptions), requestor);
    }

    private static void suggestNames(char[] packageName, char[] qualifiedTypeName, int dim, char[][] prefixes, char[][] suffixes, char[][] excludedNames, Scanner nameScanner, INamingRequestor requestor) {
        int length;
        if (qualifiedTypeName == null || qualifiedTypeName.length == 0) {
            return;
        }
        char[] typeName = CharOperation.lastSegment(qualifiedTypeName, '.');
        if (prefixes == null || ((char[][])prefixes).length == 0) {
            prefixes = new char[1][0];
        } else {
            length = ((char[][])prefixes).length;
            char[][] cArray = prefixes;
            char[][] cArrayArray = new char[length + 1][];
            prefixes = cArrayArray;
            System.arraycopy(cArray, 0, cArrayArray, 0, length);
            prefixes[length] = CharOperation.NO_CHAR;
        }
        if (suffixes == null || ((char[][])suffixes).length == 0) {
            suffixes = new char[1][0];
        } else {
            length = ((char[][])suffixes).length;
            char[][] cArray = suffixes;
            char[][] cArrayArray = new char[length + 1][];
            suffixes = cArrayArray;
            System.arraycopy(cArray, 0, cArrayArray, 0, length);
            suffixes[length] = CharOperation.NO_CHAR;
        }
        Object tempNames = null;
        try {
            nameScanner.setSource(typeName);
            switch (nameScanner.getNextToken()) {
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: {
                    char[] name = InternalNamingConventions.computeBaseTypeNames(typeName[0], excludedNames);
                    if (name == null) break;
                    tempNames = new char[][]{name};
                }
            }
        }
        catch (InvalidInputException e) {
            // empty catch block
        }
        if (tempNames == null) {
            tempNames = InternalNamingConventions.computeNames(typeName);
        }
        boolean acceptDefaultName = true;
        for (int i = 0; i < ((char[][])tempNames).length; ++i) {
            char[] tempName = tempNames[i];
            if (dim > 0) {
                int length2 = tempName.length;
                if (tempName[length2 - 1] == 's') {
                    if (tempName.length > 1 && tempName[length2 - 2] == 's') {
                        char[] cArray = tempName;
                        tempName = new char[length2 + 2];
                        System.arraycopy(cArray, 0, tempName, 0, length2);
                        tempName[length2] = 101;
                        tempName[length2 + 1] = 115;
                    }
                } else if (tempName[length2 - 1] == 'y') {
                    char[] cArray = tempName;
                    tempName = new char[length2 + 2];
                    System.arraycopy(cArray, 0, tempName, 0, length2);
                    tempName[length2 - 1] = 105;
                    tempName[length2] = 101;
                    tempName[length2 + 1] = 115;
                } else {
                    char[] cArray = tempName;
                    tempName = new char[length2 + 1];
                    System.arraycopy(cArray, 0, tempName, 0, length2);
                    tempName[length2] = 115;
                }
            }
            for (int j = 0; j < ((char[][])prefixes).length; ++j) {
                tempName[0] = prefixes[j].length > 0 && Character.isLetterOrDigit(prefixes[j][prefixes[j].length - 1]) ? Character.toUpperCase(tempName[0]) : Character.toLowerCase(tempName[0]);
                char[] prefixName = CharOperation.concat(prefixes[j], tempName);
                for (int k = 0; k < ((char[][])suffixes).length; ++k) {
                    char[] suffixName = CharOperation.concat(prefixName, suffixes[k]);
                    if (JavaConventions.validateFieldName(new String(suffixName = InternalNamingConventions.excludeNames(suffixName, prefixName, suffixes[k], excludedNames))).isOK()) {
                        InternalNamingConventions.acceptName(suffixName, prefixes[j], suffixes[k], j == 0, k == 0, requestor);
                        acceptDefaultName = false;
                        continue;
                    }
                    suffixName = CharOperation.concat(prefixName, String.valueOf(1).toCharArray(), suffixes[k]);
                    if (!JavaConventions.validateFieldName(new String(suffixName = InternalNamingConventions.excludeNames(suffixName, prefixName, suffixes[k], excludedNames))).isOK()) continue;
                    InternalNamingConventions.acceptName(suffixName, prefixes[j], suffixes[k], j == 0, k == 0, requestor);
                    acceptDefaultName = false;
                }
            }
        }
        if (acceptDefaultName) {
            char[] name = InternalNamingConventions.excludeNames(DEFAULT_NAME, DEFAULT_NAME, CharOperation.NO_CHAR, excludedNames);
            requestor.acceptNameWithoutPrefixAndSuffix(name);
        }
    }

    private static void acceptName(char[] name, char[] prefix, char[] suffix, boolean isFirstPrefix, boolean isFirstSuffix, INamingRequestor requestor) {
        if (prefix.length > 0 && suffix.length > 0) {
            requestor.acceptNameWithPrefixAndSuffix(name, isFirstPrefix, isFirstSuffix);
        } else if (prefix.length > 0) {
            requestor.acceptNameWithPrefix(name, isFirstPrefix);
        } else if (suffix.length > 0) {
            requestor.acceptNameWithSuffix(name, isFirstSuffix);
        } else {
            requestor.acceptNameWithoutPrefixAndSuffix(name);
        }
    }

    private static char[] computeBaseTypeNames(char firstName, char[][] excludedNames) {
        char[] name = new char[]{firstName};
        for (int i = 0; i < excludedNames.length; ++i) {
            if (!CharOperation.equals(name, excludedNames[i], false)) continue;
            name[0] = (char)(name[0] + '\u0001');
            if (name[0] > 'z') {
                name[0] = 97;
            }
            if (name[0] == firstName) {
                return null;
            }
            i = 0;
        }
        return name;
    }

    private static char[][] computeNames(char[] sourceName) {
        char[][] names = new char[5][];
        int nameCount = 0;
        boolean previousIsUpperCase = false;
        boolean previousIsLetter = true;
        for (int i = sourceName.length - 1; i >= 0; --i) {
            char[] name;
            boolean isUpperCase = Character.isUpperCase(sourceName[i]);
            boolean isLetter = Character.isLetter(sourceName[i]);
            if (isUpperCase && !previousIsUpperCase && previousIsLetter && (name = CharOperation.subarray(sourceName, i, sourceName.length)).length > 1) {
                if (nameCount == names.length) {
                    char[][] cArrayArray = names;
                    names = new char[nameCount * 2][];
                    System.arraycopy(cArrayArray, 0, names, 0, nameCount);
                }
                name[0] = Character.toLowerCase(name[0]);
                names[nameCount++] = name;
            }
            previousIsUpperCase = isUpperCase;
            previousIsLetter = isLetter;
        }
        if (nameCount == 0) {
            names[nameCount++] = CharOperation.toLowerCase(sourceName);
        }
        char[][] cArrayArray = names;
        names = new char[nameCount][];
        System.arraycopy(cArrayArray, 0, names, 0, nameCount);
        return names;
    }

    private static char[] excludeNames(char[] suffixName, char[] prefixName, char[] suffix, char[][] excludedNames) {
        int count = 2;
        int m = 0;
        while (m < excludedNames.length) {
            if (CharOperation.equals(suffixName, excludedNames[m], false)) {
                suffixName = CharOperation.concat(prefixName, String.valueOf(count++).toCharArray(), suffix);
                m = 0;
                continue;
            }
            ++m;
        }
        return suffixName;
    }
}

