/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;

public class JavaWatchExpressionDelegate
implements IWatchExpressionDelegate {
    private String fExpressionText;
    private IWatchExpressionListener fListener;
    static /* synthetic */ Class class$org$eclipse$jdt$debug$core$IJavaStackFrame;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;

    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        this.fExpressionText = expression;
        this.fListener = listener;
        IStackFrame frame = null;
        if (context instanceof IStackFrame) {
            frame = (IStackFrame)context;
        } else if (context instanceof IThread) {
            try {
                frame = ((IThread)context).getTopStackFrame();
            }
            catch (DebugException e) {
                // empty catch block
            }
        }
        if (frame == null) {
            this.fListener.watchEvaluationFinished(null);
        } else {
            IJavaStackFrame javaStackFrame = (IJavaStackFrame)frame.getAdapter(class$org$eclipse$jdt$debug$core$IJavaStackFrame == null ? (class$org$eclipse$jdt$debug$core$IJavaStackFrame = JavaWatchExpressionDelegate.class$("org.eclipse.jdt.debug.core.IJavaStackFrame")) : class$org$eclipse$jdt$debug$core$IJavaStackFrame);
            if (javaStackFrame != null) {
                this.doEvaluation(javaStackFrame);
            } else {
                this.fListener.watchEvaluationFinished(null);
            }
        }
    }

    protected void doEvaluation(IJavaStackFrame javaStackFrame) {
        IJavaThread thread = (IJavaThread)javaStackFrame.getThread();
        if (this.preEvaluationCheck(thread)) {
            thread.queueRunnable((Runnable)new EvaluationRunnable(javaStackFrame));
        } else {
            this.fListener.watchEvaluationFinished(null);
        }
    }

    private boolean preEvaluationCheck(IJavaThread javaThread) {
        if (javaThread == null) {
            return false;
        }
        return !javaThread.isSuspended() || !((JDIThread)javaThread).isInvokingMethod();
    }

    private IJavaProject getProject(IJavaStackFrame javaStackFrame) {
        ILaunch launch = javaStackFrame.getLaunch();
        if (launch == null) {
            return null;
        }
        ISourceLocator locator = launch.getSourceLocator();
        if (locator == null) {
            return null;
        }
        Object sourceElement = locator.getSourceElement((IStackFrame)javaStackFrame);
        if (!(sourceElement instanceof IJavaElement) && sourceElement instanceof IAdaptable) {
            sourceElement = ((IAdaptable)sourceElement).getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = JavaWatchExpressionDelegate.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement);
        }
        if (sourceElement instanceof IJavaElement) {
            return ((IJavaElement)sourceElement).getJavaProject();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class EvaluationRunnable
    implements Runnable {
        private final IJavaStackFrame fStackFrame;

        private EvaluationRunnable(IJavaStackFrame frame) {
            this.fStackFrame = frame;
        }

        public void run() {
            IJavaProject project = JavaWatchExpressionDelegate.this.getProject(this.fStackFrame);
            if (project == null) {
                JavaWatchExpressionDelegate.this.fListener.watchEvaluationFinished(null);
                return;
            }
            IAstEvaluationEngine evaluationEngine = JDIDebugUIPlugin.getDefault().getEvaluationEngine(project, (IJavaDebugTarget)this.fStackFrame.getDebugTarget());
            IEvaluationListener listener = new IEvaluationListener(){

                public void evaluationComplete(IEvaluationResult result) {
                    IWatchExpressionResult watchResult = new IWatchExpressionResult(this, result){
                        private final /* synthetic */ IEvaluationResult val$result;
                        private final /* synthetic */ 1 this$2;
                        {
                            this.this$2 = this$2;
                            this.val$result = val$result;
                        }

                        public IValue getValue() {
                            return this.val$result.getValue();
                        }

                        public boolean hasErrors() {
                            return this.val$result.hasErrors();
                        }

                        public String[] getErrorMessages() {
                            return JavaInspectExpression.getErrorMessages(this.val$result);
                        }

                        public String getExpressionText() {
                            return this.val$result.getSnippet();
                        }

                        public DebugException getException() {
                            return this.val$result.getException();
                        }
                    };
                    JavaWatchExpressionDelegate.this.fListener.watchEvaluationFinished(watchResult);
                }
            };
            try {
                evaluationEngine.evaluate(JavaWatchExpressionDelegate.this.fExpressionText, this.fStackFrame, listener, 128, false);
            }
            catch (DebugException e) {
                JDIDebugPlugin.log((Throwable)e);
                JavaWatchExpressionDelegate.this.fListener.watchEvaluationFinished(null);
            }
        }
    }
}

