/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.parts;

import org.eclipse.pde.internal.ui.parts.IFormEntryListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class FormEntry {
    private Control label;
    private Text text;
    private Button browse;
    private String value;
    private boolean dirty;
    boolean ignoreModify = false;
    private IFormEntryListener listener;

    public FormEntry(Composite parent, FormToolkit toolkit, String labelText, int style) {
        this.createControl(parent, toolkit, labelText, style, null, false);
    }

    public FormEntry(Composite parent, FormToolkit toolkit, String labelText, String browseText, boolean linkLabel) {
        this.createControl(parent, toolkit, labelText, 4, browseText, linkLabel);
    }

    private void createControl(Composite parent, FormToolkit toolkit, String labelText, int style, String browseText, boolean linkLabel) {
        if (linkLabel) {
            Hyperlink link = toolkit.createHyperlink(parent, labelText, 0);
            this.label = link;
        } else {
            this.label = toolkit.createLabel(parent, labelText);
            this.label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        }
        this.text = toolkit.createText(parent, "", style);
        this.addListeners();
        if (browseText != null) {
            this.browse = toolkit.createButton(parent, browseText, 8);
            this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FormEntry.this.listener != null) {
                        FormEntry.this.listener.browseButtonSelected(FormEntry.this);
                    }
                }
            });
        }
        this.fillIntoGrid(parent);
    }

    public void setEditable(boolean editable) {
        this.text.setEditable(editable);
        if (this.browse != null) {
            this.browse.setEnabled(editable);
        }
    }

    private void fillIntoGrid(Composite parent) {
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            int span = ((GridLayout)layout).numColumns;
            GridData gd = new GridData(4);
            this.label.setLayoutData((Object)gd);
            int tspan = this.browse != null ? span - 2 : span - 1;
            gd = new GridData(256);
            gd.horizontalSpan = tspan;
            gd.grabExcessHorizontalSpace = tspan == 1;
            gd.widthHint = 10;
            this.text.setLayoutData((Object)gd);
            if (this.browse != null) {
                gd = new GridData(4);
                this.browse.setLayoutData((Object)gd);
            }
        } else if (layout instanceof TableWrapLayout) {
            int span = ((TableWrapLayout)layout).numColumns;
            TableWrapData td = new TableWrapData();
            td.valign = 32;
            this.label.setLayoutData((Object)td);
            int tspan = this.browse != null ? span - 2 : span - 1;
            td = new TableWrapData(128);
            td.colspan = tspan;
            td.grabHorizontal = tspan == 1;
            this.text.setLayoutData((Object)td);
            if (this.browse != null) {
                td = new TableWrapData();
                td.valign = 32;
                this.browse.setLayoutData((Object)td);
            }
        }
    }

    public void setFormEntryListener(IFormEntryListener listener) {
        if (this.label instanceof Hyperlink) {
            if (this.listener != null) {
                ((Hyperlink)this.label).removeHyperlinkListener((IHyperlinkListener)this.listener);
            }
            if (listener != null) {
                ((Hyperlink)this.label).addHyperlinkListener((IHyperlinkListener)listener);
            }
        }
        this.listener = listener;
    }

    private void addListeners() {
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                FormEntry.this.keyReleaseOccured(e);
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormEntry.this.editOccured(e);
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (FormEntry.this.listener != null) {
                    FormEntry.this.listener.focusGained(FormEntry.this);
                }
            }

            public void focusLost(FocusEvent e) {
                if (FormEntry.this.dirty) {
                    FormEntry.this.commit();
                }
            }
        });
    }

    public void commit() {
        if (this.dirty) {
            this.value = this.text.getText();
            if (this.listener != null) {
                this.listener.textValueChanged(this);
            }
        }
        this.dirty = false;
    }

    public void cancelEdit() {
        this.dirty = false;
    }

    private void editOccured(ModifyEvent e) {
        if (this.ignoreModify) {
            return;
        }
        this.dirty = true;
        if (this.listener != null) {
            this.listener.textDirty(this);
        }
    }

    public Text getText() {
        return this.text;
    }

    public Button getButton() {
        return this.browse;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void keyReleaseOccured(KeyEvent e) {
        if (e.character == '\r') {
            if (this.dirty) {
                this.commit();
            }
        } else if (e.character == '\u001b') {
            this.text.setText(this.value != null ? this.value : "");
            this.dirty = false;
        }
    }

    public void setValue(String value) {
        if (this.text != null) {
            this.text.setText(value != null ? value : "");
        }
        this.value = value != null ? value : "";
    }

    public void setValue(String value, boolean blockNotification) {
        this.ignoreModify = blockNotification;
        this.setValue(value);
        this.ignoreModify = false;
    }
}

