/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import java.io.File;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.pde.core.ISourceObject;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.search.IPluginSearchResultCollector;
import org.eclipse.pde.internal.core.search.PluginSearchOperation;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.search.PluginSearchActionGroupFactory;
import org.eclipse.pde.internal.ui.search.PluginSearchLabelProvider;
import org.eclipse.pde.internal.ui.search.PluginSearchUIOperation;
import org.eclipse.pde.internal.ui.search.SearchGoToAction;
import org.eclipse.search.ui.IActionGroupFactory;
import org.eclipse.search.ui.IGroupByKeyComputer;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.SearchUI;

public class PluginSearchResultCollector
implements IPluginSearchResultCollector {
    private static final String KEY_MATCH = "Search.singleMatch";
    private static final String KEY_MATCHES = "Search.multipleMatches";
    private PluginSearchUIOperation operation;
    private ISearchResultView resultView;
    private IProgressMonitor monitor;
    private int numMatches = 0;
    private static final String pageID = "org.eclipse.pde.internal.ui.search.SearchPage";

    public void setOperation(PluginSearchOperation operation) {
        this.operation = (PluginSearchUIOperation)operation;
    }

    public PluginSearchOperation getOperation() {
        return this.operation;
    }

    public void accept(IPluginObject match) {
        try {
            IResource resource = match.getModel().getUnderlyingResource();
            if (resource == null) {
                resource = PDEPlugin.getWorkspace().getRoot();
            }
            IMarker marker = resource.createMarker("org.eclipse.search.searchmarker");
            if (match instanceof ISourceObject) {
                marker.setAttribute("lineNumber", ((ISourceObject)match).getStartLine());
            }
            if (match.getModel().getUnderlyingResource() == null) {
                this.annotateExternalMarker(marker, match);
            }
            this.resultView.addMatch(null, (Object)match, resource, marker);
            ++this.numMatches;
            String text = this.numMatches > 1 ? PDEPlugin.getResourceString(KEY_MATCHES) : PDEPlugin.getResourceString(KEY_MATCH);
            this.monitor.subTask(this.numMatches + " " + text);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void annotateExternalMarker(IMarker marker, IPluginObject match) throws CoreException {
        IPluginModelBase model = match.getPluginModel();
        String path = model.getInstallLocation();
        String manifest = model.isFragmentModel() ? "fragment.xml" : "plugin.xml";
        String fileName = path + File.separator + manifest;
        marker.setAttribute("org.eclipse.pde.ui.systemFilePath", (Object)fileName);
    }

    public void done() {
        if (this.resultView != null) {
            this.resultView.searchFinished();
        }
    }

    public void searchStarted() {
        this.resultView = SearchUI.getSearchResultView();
        this.resultView.searchStarted((IActionGroupFactory)new PluginSearchActionGroupFactory(), this.operation.getSingularLabel(), this.operation.getPluralLabel(), null, pageID, (ILabelProvider)new PluginSearchLabelProvider(), (IAction)new SearchGoToAction(), (IGroupByKeyComputer)new GroupByKeyComputer(), (IRunnableWithProgress)this.operation);
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    class GroupByKeyComputer
    implements IGroupByKeyComputer {
        GroupByKeyComputer() {
        }

        public Object computeGroupByKey(IMarker marker) {
            return marker;
        }
    }
}

