/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;

public class VersionedIdentifier {
    private String id;
    private PluginVersionIdentifier version;
    private static final String SEPARATOR = "_";

    public VersionedIdentifier(String id, String versionName) {
        if (id == null || (id = id.trim()).equals("")) {
            throw new IllegalArgumentException(Policy.bind("VersionedIdentifier.IdOrVersionNull", id, versionName));
        }
        this.id = id;
        if (versionName != null) {
            try {
                this.version = new PluginVersionIdentifier(versionName);
            }
            catch (RuntimeException e) {
                UpdateCore.warn("Invalid Version:" + versionName, e);
            }
        }
        if (this.version == null) {
            this.version = new PluginVersionIdentifier(0, 0, 0);
        }
    }

    public String getIdentifier() {
        return this.id;
    }

    public PluginVersionIdentifier getVersion() {
        return this.version;
    }

    public String toString() {
        return this.id.equals("") ? "" : this.id + SEPARATOR + this.version.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VersionedIdentifier)) {
            return false;
        }
        VersionedIdentifier vid = (VersionedIdentifier)obj;
        if (!this.id.equals(vid.id)) {
            return false;
        }
        return this.version.equals((Object)vid.version);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

