/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class RetargetAction
implements IWorkbenchWindowActionDelegate,
IPartListener,
IUpdate {
    protected IWorkbenchWindow window = null;
    private IWorkbenchPart activePart = null;
    private Object targetAdapter = null;
    private IAction action = null;
    private static final ISelection EMPTY_SELECTION = new EmptySelection();

    private ISelection getTargetSelection() {
        ISelectionProvider selectionProvider;
        if (this.activePart != null && (selectionProvider = this.activePart.getSite().getSelectionProvider()) != null) {
            return selectionProvider.getSelection();
        }
        return EMPTY_SELECTION;
    }

    public void dispose() {
        this.window.getPartService().removePartListener((IPartListener)this);
        this.activePart = null;
        this.targetAdapter = null;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
        IPartService partService = window.getPartService();
        partService.addPartListener((IPartListener)this);
        IWorkbenchPart part = partService.getActivePart();
        if (part != null) {
            this.partActivated(part);
        }
    }

    public void run(IAction action) {
        if (this.targetAdapter != null) {
            try {
                this.performAction(this.targetAdapter, this.getTargetSelection(), this.activePart);
            }
            catch (CoreException e) {
                DebugUIPlugin.errorDialog(this.window.getShell(), ActionMessages.getString("RetargetAction.2"), ActionMessages.getString("RetargetAction.3"), e.getStatus());
            }
        }
    }

    protected abstract void performAction(Object var1, ISelection var2, IWorkbenchPart var3) throws CoreException;

    public void selectionChanged(IAction action, ISelection selection) {
        Object object;
        IStructuredSelection ss;
        this.action = action;
        if (this.targetAdapter == null && selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty() && (object = ss.getFirstElement()) instanceof IAdaptable) {
            this.targetAdapter = this.getAdapter((IAdaptable)object);
        }
        this.update();
    }

    public void partActivated(IWorkbenchPart part) {
        this.activePart = part;
        this.targetAdapter = this.getAdapter((IAdaptable)part);
        this.update();
    }

    protected Object getAdapter(IAdaptable adaptable) {
        IAdapterManager adapterManager;
        Object adapter = adaptable.getAdapter(this.getAdapterClass());
        if (adapter == null && (adapterManager = Platform.getAdapterManager()).hasAdapter((Object)adaptable, this.getAdapterClass().getName())) {
            this.targetAdapter = adapterManager.loadAdapter((Object)adaptable, this.getAdapterClass().getName());
        }
        return adapter;
    }

    protected abstract Class getAdapterClass();

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        this.clearPart(part);
    }

    protected void clearPart(IWorkbenchPart part) {
        if (part.equals(this.activePart)) {
            this.activePart = null;
            this.targetAdapter = null;
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        this.clearPart(part);
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void update() {
        if (this.action == null) {
            return;
        }
        if (this.targetAdapter != null) {
            this.action.setEnabled(this.canPerformAction(this.targetAdapter, this.getTargetSelection(), this.activePart));
        } else {
            this.action.setEnabled(false);
        }
    }

    protected abstract boolean canPerformAction(Object var1, ISelection var2, IWorkbenchPart var3);

    static class EmptySelection
    implements ISelection {
        EmptySelection() {
        }

        public boolean isEmpty() {
            return true;
        }
    }
}

