/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.Corext;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.jdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.JavadocUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.TextEditGroup;

public class IntroduceParameterRefactoring
extends Refactoring {
    private static final String[] KNOWN_METHOD_NAME_PREFIXES = new String[]{"get", "is"};
    private ICompilationUnit fSourceCU;
    private int fSelectionStart;
    private int fSelectionLength;
    private String fParameterName;
    private CompilationUnitRewrite fSource;
    private Expression fSelectedExpression;
    private MethodDeclaration fMethodDeclaration;
    private String[] fExcludedParameterNames;
    private CompositeChange fChange;
    private ICompilationUnit[] fAffectedCUs;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$MethodDeclaration;

    private IntroduceParameterRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength) {
        Assert.isTrue(cu != null && cu.exists());
        Assert.isTrue(selectionStart >= 0);
        Assert.isTrue(selectionLength >= 0);
        this.fSourceCU = cu;
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fParameterName = "";
    }

    public static boolean isAvailable(ASTNode[] selectedNodes, ASTNode coveringNode) {
        return Checks.isExtractableExpression(selectedNodes, coveringNode);
    }

    public static IntroduceParameterRefactoring create(ICompilationUnit cu, int selectionStart, int selectionLength) {
        return new IntroduceParameterRefactoring(cu, selectionStart, selectionLength);
    }

    public String getName() {
        return RefactoringCoreMessages.getString("IntroduceParameterRefactoring.name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 7);
            if (!this.fSourceCU.isStructureKnown()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("IntroduceParameterRefactoring.syntax_error"));
                return refactoringStatus;
            }
            pm.worked(1);
            this.fSource = new CompilationUnitRewrite(this.fSourceCU);
            this.initializeSelectedExpression();
            pm.worked(1);
            RefactoringStatus result = this.checkSelection((IProgressMonitor)new SubProgressMonitor(pm, 5));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.initializeExcludedParameterNames();
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private void initializeSelectedExpression() throws JavaModelException {
        IASTFragment fragment = ASTFragmentFactory.createFragmentForSourceRange(new SourceRange(this.fSelectionStart, this.fSelectionLength), (ASTNode)this.fSource.getRoot(), this.fSource.getCu());
        if (!(fragment instanceof IExpressionFragment)) {
            return;
        }
        Expression expression = ((IExpressionFragment)fragment).getAssociatedExpression();
        if (fragment.getStartPosition() != expression.getStartPosition() || fragment.getLength() != expression.getLength()) {
            return;
        }
        if (Checks.isInsideJavadoc((ASTNode)expression)) {
            return;
        }
        this.fSelectedExpression = expression;
    }

    private RefactoringStatus checkSelection(IProgressMonitor pm) {
        if (this.fSelectedExpression == null) {
            String message = RefactoringCoreMessages.getString("IntroduceParameterRefactoring.select");
            return CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, this.fSource.getRoot(), message);
        }
        this.fMethodDeclaration = (MethodDeclaration)ASTNodes.getParent((ASTNode)this.fSelectedExpression, class$org$eclipse$jdt$core$dom$MethodDeclaration == null ? (class$org$eclipse$jdt$core$dom$MethodDeclaration = IntroduceParameterRefactoring.class$("org.eclipse.jdt.core.dom.MethodDeclaration")) : class$org$eclipse$jdt$core$dom$MethodDeclaration);
        if (this.fMethodDeclaration == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("IntroduceParameterRefactoring.expression_in_method"));
        }
        if (this.fMethodDeclaration.resolveBinding() == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("IntroduceParameterRefactoring.no_binding"));
        }
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.checkExpression());
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(this.checkExpressionBinding());
        if (result.hasFatalError()) {
            return result;
        }
        return result;
    }

    private RefactoringStatus checkExpression() {
        Expression selectedExpression = this.fSelectedExpression;
        if (selectedExpression instanceof Name && selectedExpression.getParent() instanceof ClassInstanceCreation) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractTempRefactoring.name_in_new"));
        }
        if (selectedExpression instanceof NullLiteral) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractTempRefactoring.null_literals"));
        }
        if (selectedExpression instanceof ArrayInitializer) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractTempRefactoring.array_initializer"));
        }
        if (selectedExpression instanceof Assignment) {
            if (selectedExpression.getParent() instanceof Expression) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractTempRefactoring.assignment"));
            }
            return null;
        }
        if (selectedExpression instanceof ConditionalExpression) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractTempRefactoring.single_conditional_expression"));
        }
        if (selectedExpression instanceof SimpleName) {
            if (((SimpleName)selectedExpression).isDeclaration()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractTempRefactoring.names_in_declarations"));
            }
            if (selectedExpression.getParent() instanceof QualifiedName && selectedExpression.getLocationInParent() == QualifiedName.NAME_PROPERTY || selectedExpression.getParent() instanceof FieldAccess && selectedExpression.getLocationInParent() == FieldAccess.NAME_PROPERTY) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractTempRefactoring.select_expression"));
            }
        }
        return null;
    }

    private RefactoringStatus checkExpressionBinding() {
        return this.checkExpressionFragmentIsRValue();
    }

    private RefactoringStatus checkExpressionFragmentIsRValue() {
        switch (Checks.checkExpressionIsRValue(this.fSelectedExpression)) {
            case 1: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.getString("IntroduceParameterRefactoring.select"), null, (String)Corext.getPluginId(), (int)64, null);
            }
            case 2: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.getString("IntroduceParameterRefactoring.no_void"), null, (String)Corext.getPluginId(), (int)65, null);
            }
            case 0: {
                return new RefactoringStatus();
            }
        }
        Assert.isTrue(false);
        return null;
    }

    public void setParameterName(String name) {
        Assert.isNotNull(name);
        this.fParameterName = name;
    }

    public String guessedParameterName() {
        String[] proposals = this.guessParameterNames();
        if (proposals.length == 0) {
            return this.fParameterName;
        }
        return proposals[0];
    }

    public String[] guessParameterNames() {
        LinkedHashSet proposals = new LinkedHashSet();
        String[] excludedVariableNames = this.getExcludedVariableNames();
        if (this.fSelectedExpression instanceof MethodInvocation) {
            proposals.addAll(this.guessTempNamesFromMethodInvocation((MethodInvocation)this.fSelectedExpression, excludedVariableNames));
        }
        proposals.addAll(this.guessTempNamesFromExpression(this.fSelectedExpression, excludedVariableNames));
        return proposals.toArray(new String[proposals.size()]);
    }

    private List guessTempNamesFromMethodInvocation(MethodInvocation selectedMethodInvocation, String[] excludedVariableNames) {
        String methodName = selectedMethodInvocation.getName().getIdentifier();
        for (int i = 0; i < KNOWN_METHOD_NAME_PREFIXES.length; ++i) {
            String proposal;
            String prefix = KNOWN_METHOD_NAME_PREFIXES[i];
            if (!methodName.startsWith(prefix)) continue;
            if (methodName.length() == prefix.length()) {
                return Collections.EMPTY_LIST;
            }
            char firstAfterPrefix = methodName.charAt(prefix.length());
            if (!Character.isUpperCase(firstAfterPrefix)) continue;
            methodName = proposal = Character.toLowerCase(firstAfterPrefix) + methodName.substring(prefix.length() + 1);
            break;
        }
        String[] proposals = StubUtility.getLocalNameSuggestions(this.fSourceCU.getJavaProject(), methodName, 0, excludedVariableNames);
        return Arrays.asList(proposals);
    }

    private List guessTempNamesFromExpression(Expression selectedExpression, String[] excluded) {
        ITypeBinding expressionBinding = selectedExpression.resolveTypeBinding();
        String typeName = IntroduceParameterRefactoring.getQualifiedName(expressionBinding);
        if (typeName.length() == 0) {
            typeName = expressionBinding.getName();
        }
        if (typeName.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        String[] proposals = StubUtility.getLocalNameSuggestions(this.fSourceCU.getJavaProject(), typeName, expressionBinding.getDimensions(), excluded);
        return Arrays.asList(proposals);
    }

    private String[] getExcludedVariableNames() {
        IBinding[] bindings = new ScopeAnalyzer(this.fSource.getRoot()).getDeclarationsInScope(this.fSelectedExpression.getStartPosition(), 2);
        String[] names = new String[bindings.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = bindings[i].getName();
        }
        return names;
    }

    private static String getQualifiedName(ITypeBinding typeBinding) {
        if (typeBinding.isAnonymous()) {
            return IntroduceParameterRefactoring.getQualifiedName(typeBinding.getSuperclass());
        }
        if (!typeBinding.isArray()) {
            return typeBinding.getQualifiedName();
        }
        return typeBinding.getElementType().getQualifiedName();
    }

    private void initializeExcludedParameterNames() {
        IBinding[] bindings = new ScopeAnalyzer(this.fSource.getRoot()).getDeclarationsInScope(this.fSelectedExpression.getStartPosition(), 2);
        this.fExcludedParameterNames = new String[bindings.length];
        for (int i = 0; i < this.fExcludedParameterNames.length; ++i) {
            this.fExcludedParameterNames[i] = bindings[i].getName();
        }
    }

    public RefactoringStatus validateInput() {
        RefactoringStatus status = this.checkExcludedParameterNames();
        if (!status.isOK()) {
            return status;
        }
        return Checks.checkTempName(this.fParameterName);
    }

    private RefactoringStatus checkExcludedParameterNames() {
        for (int i = 0; i < this.fExcludedParameterNames.length; ++i) {
            if (!this.fParameterName.equals(this.fExcludedParameterNames[i])) continue;
            return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.getString("IntroduceParameterRefactoring.duplicate_name"));
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.getString("IntroduceParameterRefactoring.preview"), 5);
        RefactoringStatus result = this.checkExcludedParameterNames();
        if (result.hasFatalError()) {
            return result;
        }
        this.fChange = new DynamicValidationStateChange(RefactoringCoreMessages.getString("IntroduceParameterRefactoring.introduce_parameter"));
        this.fSource.clearASTAndImportRewrites();
        this.changeSource();
        pm.worked(1);
        result.merge(this.changeReferences(new SubProgressMonitor(pm, 3)));
        this.fChange.add((Change)this.fSource.createChange());
        HashSet<ICompilationUnit> cus = new HashSet<ICompilationUnit>();
        cus.add(this.fSource.getCu());
        cus.addAll(Arrays.asList(this.fAffectedCUs));
        result.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(cus.toArray(new ICompilationUnit[cus.size()])), this.getValidationContext()));
        if (result.hasFatalError()) {
            return result;
        }
        pm.worked(1);
        return result;
    }

    private void changeSource() {
        this.replaceSelectedExpression();
        this.addParameter();
    }

    private void replaceSelectedExpression() {
        SimpleName newExpression = this.fSource.getRoot().getAST().newSimpleName(this.fParameterName);
        String description = RefactoringCoreMessages.getString("IntroduceParameterRefactoring.replace");
        this.fSource.getASTRewrite().replace((ASTNode)this.fSelectedExpression, (ASTNode)newExpression, this.fSource.createGroupDescription(description));
    }

    private void addParameter() {
        AST ast = this.fSource.getRoot().getAST();
        ASTRewrite astRewrite = this.fSource.getASTRewrite();
        SingleVariableDeclaration param = ast.newSingleVariableDeclaration();
        param.setName(ast.newSimpleName(this.fParameterName));
        String type = this.fSource.getImportRewrite().addImport(this.fSelectedExpression.resolveTypeBinding());
        param.setType((Type)astRewrite.createStringPlaceholder(type, 43));
        ListRewrite parameters = astRewrite.getListRewrite((ASTNode)this.fMethodDeclaration, MethodDeclaration.PARAMETERS_PROPERTY);
        String description = RefactoringCoreMessages.getString("IntroduceParameterRefactoring.add_parameter");
        TextEditGroup groupDescription = this.fSource.createGroupDescription(description);
        parameters.insertLast((ASTNode)param, groupDescription);
        JavadocUtil.addParamJavadoc(this.fParameterName, this.fMethodDeclaration, this.fSource.getASTRewrite(), this.fSource.getCu().getJavaProject(), groupDescription);
    }

    private RefactoringStatus changeReferences(SubProgressMonitor pm) throws CoreException {
        pm.beginTask("", 2);
        RefactoringStatus result = new RefactoringStatus();
        this.fAffectedCUs = this.findAffectedCompilationUnits((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pm, 1), result);
        IMethodBinding method = this.fMethodDeclaration.resolveBinding();
        SubProgressMonitor sub = new SubProgressMonitor((IProgressMonitor)pm, 1);
        sub.beginTask("", this.fAffectedCUs.length);
        for (int i = 0; i < this.fAffectedCUs.length; ++i) {
            CompilationUnitRewrite ast = this.getCURewrite(this.fAffectedCUs[i]);
            ReferenceAnalyzer analyzer = new ReferenceAnalyzer(ast, method, this.fSelectedExpression);
            ast.getRoot().accept((ASTVisitor)analyzer);
            if (ast != this.fSource) {
                this.fChange.add((Change)ast.createChange());
            }
            sub.worked(1);
            if (!sub.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        return result;
    }

    private CompilationUnitRewrite getCURewrite(ICompilationUnit unit) {
        if (this.fSource.getCu().equals(unit)) {
            return this.fSource;
        }
        return new CompilationUnitRewrite(unit);
    }

    private ICompilationUnit[] findAffectedCompilationUnits(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        IMethod method = (IMethod)this.fSourceCU.getElementAt(this.fMethodDeclaration.getName().getStartPosition());
        ICompilationUnit[] result = RefactoringSearchEngine.findAffectedCompilationUnits(SearchPattern.createPattern((IJavaElement)method, (int)2), RefactoringScopeFactory.create((IJavaElement)method), pm, status);
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.done();
        return this.fChange;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ReferenceAnalyzer
    extends ASTVisitor {
        private CompilationUnitRewrite fCURewrite;
        private IMethodBinding fMethodBinding;
        private Expression fExpression;

        public ReferenceAnalyzer(CompilationUnitRewrite cuRewrite, IMethodBinding methodBinding, Expression expression) {
            super(true);
            this.fExpression = expression;
            this.fCURewrite = cuRewrite;
            this.fMethodBinding = methodBinding;
        }

        private void addArgument(ASTRewrite astRewrite, ListRewrite argumentListRewrite) {
            Expression argument;
            if (this.fExpression.getAST() == astRewrite.getAST()) {
                argument = (Expression)astRewrite.createCopyTarget((ASTNode)this.fExpression);
            } else {
                try {
                    String expression = IntroduceParameterRefactoring.this.fSource.getCu().getBuffer().getText(this.fExpression.getStartPosition(), this.fExpression.getLength());
                    argument = (Expression)astRewrite.createStringPlaceholder(expression, 42);
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                    argument = (Expression)ASTNode.copySubtree((AST)this.fCURewrite.getRoot().getAST(), (ASTNode)this.fExpression);
                }
            }
            String description = RefactoringCoreMessages.getString("IntroduceParameterRefactoring.add_argument");
            argumentListRewrite.insertLast((ASTNode)argument, this.fCURewrite.createGroupDescription(description));
        }

        public boolean visit(MethodInvocation node) {
            if (Bindings.equals((IBinding)this.fMethodBinding, (IBinding)node.resolveMethodBinding())) {
                ASTRewrite astRewrite = this.fCURewrite.getASTRewrite();
                ListRewrite listRewrite = astRewrite.getListRewrite((ASTNode)node, MethodInvocation.ARGUMENTS_PROPERTY);
                this.addArgument(astRewrite, listRewrite);
            }
            return super.visit(node);
        }

        public boolean visit(ClassInstanceCreation node) {
            if (Bindings.equals((IBinding)this.fMethodBinding, (IBinding)node.resolveConstructorBinding())) {
                ASTRewrite astRewrite = this.fCURewrite.getASTRewrite();
                ListRewrite listRewrite = astRewrite.getListRewrite((ASTNode)node, ClassInstanceCreation.ARGUMENTS_PROPERTY);
                this.addArgument(astRewrite, listRewrite);
            }
            return super.visit(node);
        }

        public boolean visit(ConstructorInvocation node) {
            if (Bindings.equals((IBinding)this.fMethodBinding, (IBinding)node.resolveConstructorBinding())) {
                ASTRewrite astRewrite = this.fCURewrite.getASTRewrite();
                ListRewrite listRewrite = astRewrite.getListRewrite((ASTNode)node, ConstructorInvocation.ARGUMENTS_PROPERTY);
                this.addArgument(astRewrite, listRewrite);
            }
            return super.visit(node);
        }

        public boolean visit(SuperMethodInvocation node) {
            if (Bindings.equals((IBinding)this.fMethodBinding, (IBinding)node.resolveMethodBinding())) {
                ASTRewrite astRewrite = this.fCURewrite.getASTRewrite();
                ListRewrite listRewrite = astRewrite.getListRewrite((ASTNode)node, SuperMethodInvocation.ARGUMENTS_PROPERTY);
                this.addArgument(astRewrite, listRewrite);
            }
            return super.visit(node);
        }

        public boolean visit(SuperConstructorInvocation node) {
            if (Bindings.equals((IBinding)this.fMethodBinding, (IBinding)node.resolveConstructorBinding())) {
                ASTRewrite astRewrite = this.fCURewrite.getASTRewrite();
                ListRewrite listRewrite = astRewrite.getListRewrite((ASTNode)node, SuperConstructorInvocation.ARGUMENTS_PROPERTY);
                this.addArgument(astRewrite, listRewrite);
            }
            return super.visit(node);
        }

        public boolean visit(MethodRef node) {
            if (Bindings.equals((IBinding)this.fMethodBinding, node.resolveBinding())) {
                ASTRewrite astRewrite = this.fCURewrite.getASTRewrite();
                ListRewrite listRewrite = astRewrite.getListRewrite((ASTNode)node, MethodRef.PARAMETERS_PROPERTY);
                List parameters = listRewrite.getOriginalList();
                MethodRefParameter newParam = astRewrite.getAST().newMethodRefParameter();
                if (parameters.size() > 0 && ((MethodRefParameter)parameters.get(0)).getName() != null) {
                    newParam.setName(astRewrite.getAST().newSimpleName(IntroduceParameterRefactoring.this.fParameterName));
                }
                String type = this.fCURewrite.getImportRewrite().addImport(IntroduceParameterRefactoring.this.fSelectedExpression.resolveTypeBinding());
                newParam.setType((Type)astRewrite.createStringPlaceholder(type, 43));
                String description = RefactoringCoreMessages.getString("IntroduceParameterRefactoring.add_javadoc_parameter");
                listRewrite.insertLast((ASTNode)newParam, this.fCURewrite.createGroupDescription(description));
            }
            return false;
        }
    }
}

