/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class JavaElementImageDescriptor
extends CompositeImageDescriptor {
    public static final int ABSTRACT = 1;
    public static final int FINAL = 2;
    public static final int SYNCHRONIZED = 4;
    public static final int STATIC = 8;
    public static final int RUNNABLE = 16;
    public static final int WARNING = 32;
    public static final int ERROR = 64;
    public static final int OVERRIDES = 128;
    public static final int IMPLEMENTS = 256;
    public static final int CONSTRUCTOR = 512;
    public static final int DEPRECATED = 1024;
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;
    static /* synthetic */ Class class$org$eclipse$jdt$ui$JavaElementImageDescriptor;

    public JavaElementImageDescriptor(ImageDescriptor baseImage, int flags, Point size) {
        this.fBaseImage = baseImage;
        Assert.isNotNull((Object)this.fBaseImage);
        this.fFlags = flags;
        Assert.isTrue((this.fFlags >= 0 ? 1 : 0) != 0);
        this.fSize = size;
        Assert.isNotNull((Object)this.fSize);
    }

    public void setAdornments(int adornments) {
        Assert.isTrue((adornments >= 0 ? 1 : 0) != 0);
        this.fFlags = adornments;
    }

    public int getAdronments() {
        return this.fFlags;
    }

    public void setImageSize(Point size) {
        Assert.isNotNull((Object)size);
        Assert.isTrue((size.x >= 0 && size.y >= 0 ? 1 : 0) != 0);
        this.fSize = size;
    }

    public Point getImageSize() {
        return new Point(this.fSize.x, this.fSize.y);
    }

    protected Point getSize() {
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (object == null || !(class$org$eclipse$jdt$ui$JavaElementImageDescriptor == null ? (class$org$eclipse$jdt$ui$JavaElementImageDescriptor = JavaElementImageDescriptor.class$("org.eclipse.jdt.ui.JavaElementImageDescriptor")) : class$org$eclipse$jdt$ui$JavaElementImageDescriptor).equals(object.getClass())) {
            return false;
        }
        JavaElementImageDescriptor other = (JavaElementImageDescriptor)((Object)object);
        return this.fBaseImage.equals(other.fBaseImage) && this.fFlags == other.fFlags && this.fSize.equals((Object)other.fSize);
    }

    public int hashCode() {
        return this.fBaseImage.hashCode() | this.fFlags | this.fSize.hashCode();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getImageData(this.fBaseImage);
        if ((this.fFlags & 0x400) != 0) {
            Point size = this.getSize();
            ImageData data = this.getImageData(JavaPluginImages.DESC_OVR_DEPRECATED);
            this.drawImage(data, 0, size.y - data.height);
        }
        this.drawImage(bg, 0, 0);
        this.drawTopRight();
        this.drawBottomRight();
        this.drawBottomLeft();
    }

    private ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
            JavaPlugin.logErrorMessage("Image data not available: " + descriptor.toString());
        }
        return data;
    }

    private void drawTopRight() {
        ImageData data;
        int x = this.getSize().x;
        if ((this.fFlags & 1) != 0) {
            data = this.getImageData(JavaPluginImages.DESC_OVR_ABSTRACT);
            this.drawImage(data, x -= data.width, 0);
        }
        if ((this.fFlags & 0x200) != 0) {
            data = this.getImageData(JavaPluginImages.DESC_OVR_CONSTRUCTOR);
            this.drawImage(data, x -= data.width, 0);
        }
        if ((this.fFlags & 2) != 0) {
            data = this.getImageData(JavaPluginImages.DESC_OVR_FINAL);
            this.drawImage(data, x -= data.width, 0);
        }
        if ((this.fFlags & 8) != 0) {
            data = this.getImageData(JavaPluginImages.DESC_OVR_STATIC);
            this.drawImage(data, x -= data.width, 0);
        }
    }

    private void drawBottomRight() {
        ImageData data;
        Point size = this.getSize();
        int x = size.x;
        int flags = this.fFlags;
        int syncAndOver = 132;
        int syncAndImpl = 260;
        if ((flags & syncAndOver) == syncAndOver) {
            data = this.getImageData(JavaPluginImages.DESC_OVR_SYNCH_AND_OVERRIDES);
            this.drawImage(data, x -= data.width, size.y - data.height);
            flags &= ~syncAndOver;
        } else if ((flags & syncAndImpl) == syncAndImpl) {
            data = this.getImageData(JavaPluginImages.DESC_OVR_SYNCH_AND_IMPLEMENTS);
            this.drawImage(data, x -= data.width, size.y - data.height);
            flags &= ~syncAndImpl;
        }
        if ((flags & 0x80) != 0) {
            data = this.getImageData(JavaPluginImages.DESC_OVR_OVERRIDES);
            this.drawImage(data, x -= data.width, size.y - data.height);
        }
        if ((flags & 0x100) != 0) {
            data = this.getImageData(JavaPluginImages.DESC_OVR_IMPLEMENTS);
            this.drawImage(data, x -= data.width, size.y - data.height);
        }
        if ((flags & 4) != 0) {
            data = this.getImageData(JavaPluginImages.DESC_OVR_SYNCH);
            this.drawImage(data, x -= data.width, size.y - data.height);
        }
        if ((flags & 0x10) != 0) {
            data = this.getImageData(JavaPluginImages.DESC_OVR_RUN);
            this.drawImage(data, x -= data.width, size.y - data.height);
        }
    }

    private void drawBottomLeft() {
        ImageData data;
        Point size = this.getSize();
        int x = 0;
        if ((this.fFlags & 0x40) != 0) {
            data = this.getImageData(JavaPluginImages.DESC_OVR_ERROR);
            this.drawImage(data, x, size.y - data.height);
            x += data.width;
        }
        if ((this.fFlags & 0x20) != 0) {
            data = this.getImageData(JavaPluginImages.DESC_OVR_WARNING);
            this.drawImage(data, x, size.y - data.height);
            x += data.width;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

