/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.SubTaskInfo;

public class TaskInfo
extends SubTaskInfo {
    double preWork = 0.0;
    int totalWork = 0;

    TaskInfo(JobInfo parentJobInfo, String infoName, int total) {
        super(parentJobInfo, infoName);
        this.totalWork = total;
    }

    void addWork(double workIncrement) {
        if (this.totalWork == -1) {
            return;
        }
        this.preWork += workIncrement;
    }

    void addWork(double workIncrement, IProgressMonitor parentMonitor, int parentTicks) {
        if (this.totalWork == -1) {
            return;
        }
        this.addWork(workIncrement);
        parentMonitor.internalWorked(workIncrement * (double)parentTicks / (double)this.totalWork);
    }

    String getDisplayString() {
        if (this.totalWork == -1) {
            return this.unknownProgress();
        }
        if (this.taskName == null) {
            return this.getDisplayStringWithoutTask();
        }
        Object[] messageValues = new String[]{String.valueOf(this.getPercentDone()), this.jobInfo.getJob().getName(), this.taskName};
        return ProgressMessages.format("JobInfo.DoneMessage", messageValues);
    }

    public String getDisplayStringWithoutTask() {
        if (this.totalWork == -1) {
            return this.jobInfo.getJob().getName();
        }
        Object[] messageValues = new String[]{this.jobInfo.getJob().getName(), String.valueOf(this.getPercentDone())};
        return ProgressMessages.format("JobInfo.NoTaskNameDoneMessage", messageValues);
    }

    int getPercentDone() {
        return Math.min((int)(this.preWork * 100.0 / (double)this.totalWork), 100);
    }

    private String unknownProgress() {
        if (this.taskName == null) {
            return this.jobInfo.getJob().getName();
        }
        Object[] messageValues = new String[]{this.jobInfo.getJob().getName(), this.taskName};
        return ProgressMessages.format("JobInfo.UnknownProgress", messageValues);
    }
}

