/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal.spy;

import java.text.MessageFormat;
import org.eclipse.jdi.internal.spy.JdwpCommandPacket;
import org.eclipse.jdi.internal.spy.JdwpReplyPacket;
import org.eclipse.jdi.internal.spy.TcpIpSpyMessages;

public class JdwpConversation {
    private int fId;
    private JdwpCommandPacket fCommand;
    private JdwpReplyPacket fReply;

    JdwpConversation(int id) {
        this.fId = id;
    }

    void setCommand(JdwpCommandPacket command) {
        if (this.fCommand != null) {
            throw new IllegalArgumentException(MessageFormat.format(TcpIpSpyMessages.getString("JdwpConversation.Attempt_to_overwrite_command_with_{0}_1"), command.toString()));
        }
        this.fCommand = command;
    }

    void setReply(JdwpReplyPacket reply) {
        if (this.fReply != null) {
            throw new IllegalArgumentException(MessageFormat.format(TcpIpSpyMessages.getString("JdwpConversation.Attempt_to_overwrite_reply_with_{0}_2"), reply.toString()));
        }
        this.fReply = reply;
    }

    public JdwpCommandPacket getCommand() {
        return this.fCommand;
    }

    public JdwpReplyPacket getReply() {
        return this.fReply;
    }

    public int getId() {
        return this.fId;
    }
}

