/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ResourceBundle;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public final class TextOperationAction
extends TextEditorAction {
    private int fOperationCode = -1;
    private ITextOperationTarget fOperationTarget;
    private boolean fRunsOnReadOnly = false;
    static /* synthetic */ Class class$org$eclipse$jface$text$ITextOperationTarget;

    public TextOperationAction(ResourceBundle bundle, String prefix, ITextEditor editor, int operationCode) {
        super(bundle, prefix, editor);
        this.fOperationCode = operationCode;
        this.update();
    }

    public TextOperationAction(ResourceBundle bundle, String prefix, ITextEditor editor, int operationCode, boolean runsOnReadOnly) {
        super(bundle, prefix, editor);
        this.fOperationCode = operationCode;
        this.fRunsOnReadOnly = runsOnReadOnly;
        this.update();
    }

    public void run() {
        if (this.fOperationCode == -1 || this.fOperationTarget == null) {
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        if (!this.fRunsOnReadOnly && !this.validateEditorInputState()) {
            return;
        }
        Display display = null;
        IWorkbenchPartSite site = editor.getSite();
        Shell shell = site.getShell();
        if (shell != null && !shell.isDisposed()) {
            display = shell.getDisplay();
        }
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            public void run() {
                TextOperationAction.this.fOperationTarget.doOperation(TextOperationAction.this.fOperationCode);
            }
        });
    }

    public void update() {
        super.update();
        if (!this.fRunsOnReadOnly && !this.canModifyEditor()) {
            this.setEnabled(false);
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (this.fOperationTarget == null && editor != null && this.fOperationCode != -1) {
            this.fOperationTarget = (ITextOperationTarget)editor.getAdapter(class$org$eclipse$jface$text$ITextOperationTarget == null ? (class$org$eclipse$jface$text$ITextOperationTarget = TextOperationAction.class$("org.eclipse.jface.text.ITextOperationTarget")) : class$org$eclipse$jface$text$ITextOperationTarget);
        }
        boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
        this.setEnabled(isEnabled);
    }

    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        this.fOperationTarget = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

