/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom.fragments;

import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.SourceRange;

class Util {
    Util() {
    }

    static boolean rangeIncludesNonWhitespaceOutsideRange(SourceRange selection, SourceRange nodes, IBuffer buffer) {
        if (!selection.covers(nodes)) {
            return false;
        }
        if (!Util.isJustWhitespace(selection.getOffset(), nodes.getOffset(), buffer)) {
            return true;
        }
        return !Util.isJustWhitespaceOrComment(nodes.getOffset() + nodes.getLength(), selection.getOffset() + selection.getLength(), buffer);
    }

    private static boolean isJustWhitespace(int start, int end, IBuffer buffer) {
        if (start == end) {
            return true;
        }
        Assert.isTrue(start <= end);
        return 0 == buffer.getText(start, end - start).trim().length();
    }

    private static boolean isJustWhitespaceOrComment(int start, int end, IBuffer buffer) {
        if (start == end) {
            return true;
        }
        Assert.isTrue(start <= end);
        String trimmedText = buffer.getText(start, end - start).trim();
        if (0 == trimmedText.length()) {
            return true;
        }
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, null);
        scanner.setSource(trimmedText.toCharArray());
        try {
            return scanner.getNextToken() == 158;
        }
        catch (InvalidInputException e) {
            return false;
        }
    }
}

