/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.infoviews;

import org.eclipse.jdt.internal.ui.infoviews.InfoViewMessages;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;

class CopyToClipboardAction
extends SelectionDispatchAction {
    private static final int MAX_REPEAT_COUNT = 10;
    private Clipboard fClipboard;

    public CopyToClipboardAction(IWorkbenchSite site) {
        super(site);
        this.setText(InfoViewMessages.getString("CopyAction.label"));
        this.setToolTipText(InfoViewMessages.getString("CopyAction.tooltip"));
        this.setDescription(InfoViewMessages.getString("CopyAction.description"));
        ISharedImages workbenchImages = PlatformUI.getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY_HOVER"));
        WorkbenchHelp.setHelp((IAction)this, (String)IAbstractTextEditorHelpContextIds.COPY_ACTION);
        this.update(this.getSelection());
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(selection != null && selection.getLength() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ITextSelection selection) {
        this.fClipboard = new Clipboard(this.getShell().getDisplay());
        try {
            this.copyToClipboard(selection, 0);
        }
        finally {
            this.fClipboard.dispose();
        }
    }

    private void copyToClipboard(ITextSelection selection, int repeatCount) {
        block3: {
            try {
                this.fClipboard.setContents((Object[])new String[]{selection.getText()}, new Transfer[]{TextTransfer.getInstance()});
            }
            catch (SWTError e) {
                if (e.code != 2002 || repeatCount >= 10) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)InfoViewMessages.getString("CopyToClipboard.error.title"), (String)InfoViewMessages.getString("CopyToClipboard.error.message"))) break block3;
                this.copyToClipboard(selection, repeatCount + 1);
            }
        }
    }
}

