/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.dialogfields;

import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SelectionButtonDialogField
extends DialogField {
    private Button fButton;
    private boolean fIsSelected = false;
    private DialogField[] fAttachedDialogFields = null;
    private int fButtonStyle;

    public SelectionButtonDialogField(int buttonStyle) {
        this.fButtonStyle = buttonStyle;
    }

    public void attachDialogField(DialogField dialogField) {
        this.attachDialogFields(new DialogField[]{dialogField});
    }

    public void attachDialogFields(DialogField[] dialogFields) {
        this.fAttachedDialogFields = dialogFields;
        for (int i = 0; i < dialogFields.length; ++i) {
            dialogFields[i].setEnabled(this.fIsSelected);
        }
    }

    public boolean isAttached(DialogField editor) {
        if (this.fAttachedDialogFields != null) {
            for (int i = 0; i < this.fAttachedDialogFields.length; ++i) {
                if (this.fAttachedDialogFields[i] != editor) continue;
                return true;
            }
        }
        return false;
    }

    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Button button = this.getSelectionButton(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = nColumns;
        gd.horizontalAlignment = 4;
        if (this.fButtonStyle == 8) {
            gd.heightHint = SWTUtil.getButtonHeightHint(button);
            gd.widthHint = SWTUtil.getButtonWidthHint(button);
        }
        button.setLayoutData((Object)gd);
        return new Control[]{button};
    }

    public int getNumberOfControls() {
        return 1;
    }

    public Button getSelectionButton(Composite group) {
        if (this.fButton == null) {
            this.assertCompositeNotNull(group);
            this.fButton = new Button(group, this.fButtonStyle);
            this.fButton.setFont(group.getFont());
            this.fButton.setText(this.fLabelText);
            this.fButton.setEnabled(this.isEnabled());
            this.fButton.setSelection(this.fIsSelected);
            this.fButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    SelectionButtonDialogField.this.doWidgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    SelectionButtonDialogField.this.doWidgetSelected(e);
                }
            });
        }
        return this.fButton;
    }

    private void doWidgetSelected(SelectionEvent e) {
        if (this.isOkToUse((Control)this.fButton)) {
            this.changeValue(this.fButton.getSelection());
        }
    }

    private void changeValue(boolean newState) {
        if (this.fIsSelected != newState) {
            this.fIsSelected = newState;
            if (this.fAttachedDialogFields != null) {
                boolean focusSet = false;
                for (int i = 0; i < this.fAttachedDialogFields.length; ++i) {
                    this.fAttachedDialogFields[i].setEnabled(this.fIsSelected);
                    if (!this.fIsSelected || focusSet) continue;
                    focusSet = this.fAttachedDialogFields[i].setFocus();
                }
            }
            this.dialogFieldChanged();
        } else if (this.fButtonStyle == 8) {
            this.dialogFieldChanged();
        }
    }

    public boolean isSelected() {
        return this.fIsSelected;
    }

    public void setSelection(boolean selected) {
        this.changeValue(selected);
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setSelection(selected);
        }
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setEnabled(this.isEnabled());
        }
    }

    public void refresh() {
        super.refresh();
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setSelection(this.fIsSelected);
        }
    }
}

