/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.client.ResponseHandler;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Assert;

class StickyHandler
extends ResponseHandler {
    private final boolean setSticky;

    public StickyHandler(boolean setSticky) {
        this.setSticky = setSticky;
    }

    public String getResponseID() {
        if (this.setSticky) {
            return "Set-sticky";
        }
        return "Clear-sticky";
    }

    public void handle(Session session, String localDir, IProgressMonitor monitor) throws CVSException {
        String repositoryDir = session.readLine();
        String tag = null;
        if (this.setSticky && (tag = session.readLine()).length() == 0) {
            tag = null;
        }
        Assert.isTrue(repositoryDir.endsWith("/"));
        repositoryDir = repositoryDir.substring(0, repositoryDir.length() - 1);
        ICVSFolder folder = StickyHandler.createFolder(session, localDir, repositoryDir);
        FolderSyncInfo syncInfo = folder.getFolderSyncInfo();
        if (syncInfo == null) {
            return;
        }
        FolderSyncInfo newInfo = new FolderSyncInfo(syncInfo.getRepository(), syncInfo.getRoot(), tag != null ? new CVSEntryLineTag(tag) : null, syncInfo.getIsStatic());
        if (!syncInfo.equals(newInfo)) {
            folder.setFolderSyncInfo(newInfo);
        }
    }
}

