/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.wireadmin;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import org.osgi.service.wireadmin.WirePermissionCollection;

public final class WirePermission
extends BasicPermission {
    public static final String PRODUCE = "produce";
    public static final String CONSUME = "consume";
    private static final int ACTION_PRODUCE = 1;
    private static final int ACTION_CONSUME = 2;
    private static final int ACTION_ALL = 3;
    private static final int ACTION_NONE = 0;
    private static final int ACTION_ERROR = Integer.MIN_VALUE;
    private transient int action_mask = 0;
    private String actions = null;

    public WirePermission(String string, String string2) {
        this(string, WirePermission.getMask(string2));
    }

    WirePermission(String string, int n) {
        super(string);
        this.init(n);
    }

    private void init(int n) {
        if (n == 0 || (n & 3) != n) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = n;
    }

    /*
     * Unable to fully structure code
     */
    private static int getMask(String var0) {
        var1_1 = false;
        var2_2 = 0;
        if (var0 == null) {
            return var2_2;
        }
        var3_3 = var0.toCharArray();
        var4_4 = var3_3.length - 1;
        if (var4_4 >= 0) ** GOTO lbl33
        return var2_2;
        {
            --var4_4;
            do {
                if (var4_4 != -1 && ((var5_5 = var3_3[var4_4]) == ' ' || var5_5 == '\r' || var5_5 == '\n' || var5_5 == '\f' || var5_5 == '\t')) continue block4;
                if (!(var4_4 < 6 || var3_3[var4_4 - 6] != 'p' && var3_3[var4_4 - 6] != 'P' || var3_3[var4_4 - 5] != 'r' && var3_3[var4_4 - 5] != 'R' || var3_3[var4_4 - 4] != 'o' && var3_3[var4_4 - 4] != 'O' || var3_3[var4_4 - 3] != 'd' && var3_3[var4_4 - 3] != 'D' || var3_3[var4_4 - 2] != 'u' && var3_3[var4_4 - 2] != 'U' || var3_3[var4_4 - 1] != 'c' && var3_3[var4_4 - 1] != 'C' || var3_3[var4_4] != 'e' && var3_3[var4_4] != 'E')) {
                    var6_6 = 7;
                    var2_2 |= 1;
                } else if (!(var4_4 < 6 || var3_3[var4_4 - 6] != 'c' && var3_3[var4_4 - 6] != 'C' || var3_3[var4_4 - 5] != 'o' && var3_3[var4_4 - 5] != 'O' || var3_3[var4_4 - 4] != 'n' && var3_3[var4_4 - 4] != 'N' || var3_3[var4_4 - 3] != 's' && var3_3[var4_4 - 3] != 'S' || var3_3[var4_4 - 2] != 'u' && var3_3[var4_4 - 2] != 'U' || var3_3[var4_4 - 1] != 'm' && var3_3[var4_4 - 1] != 'M' || var3_3[var4_4] != 'e' && var3_3[var4_4] != 'E')) {
                    var6_6 = 7;
                    var2_2 |= 2;
                } else {
                    throw new IllegalArgumentException("invalid permission: " + var0);
                }
                var1_1 = false;
                while (var4_4 >= var6_6 && !var1_1) {
                    switch (var3_3[var4_4 - var6_6]) {
                        case ',': {
                            var1_1 = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid permission: " + var0);
                        }
                    }
                    --var4_4;
                }
                var4_4 -= var6_6;
lbl33:
                // 2 sources

            } while (var4_4 != -1);
        }
        if (var1_1) {
            throw new IllegalArgumentException("invalid permission: " + var0);
        }
        return var2_2;
    }

    public boolean implies(Permission permission) {
        if (permission instanceof WirePermission) {
            WirePermission wirePermission = (WirePermission)permission;
            return (this.action_mask & wirePermission.action_mask) == wirePermission.action_mask && super.implies(permission);
        }
        return false;
    }

    public String getActions() {
        if (this.actions == null) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            if ((this.action_mask & 1) == 1) {
                stringBuffer.append(PRODUCE);
                bl = true;
            }
            if ((this.action_mask & 2) == 2) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(CONSUME);
            }
            this.actions = stringBuffer.toString();
        }
        return this.actions;
    }

    public PermissionCollection newPermissionCollection() {
        return new WirePermissionCollection();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof WirePermission)) {
            return false;
        }
        WirePermission wirePermission = (WirePermission)object;
        return this.action_mask == wirePermission.action_mask && this.getName().equals(wirePermission.getName());
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getActions().hashCode();
    }

    int getMask() {
        return this.action_mask;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" \"");
        stringBuffer.append(this.getName());
        stringBuffer.append("\" \"");
        stringBuffer.append(this.getActions());
        stringBuffer.append("\")");
        return stringBuffer.toString();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(WirePermission.getMask(this.actions));
    }
}

