/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IContainmentAdapter;
import org.eclipse.ui.IWorkingSet;

public class ResourceWorkingSetFilter
extends ViewerFilter {
    private IWorkingSet workingSet = null;
    private IAdaptable[] cachedWorkingSet = null;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;
    static /* synthetic */ Class class$org$eclipse$ui$IContainmentAdapter;

    public IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        this.workingSet = workingSet;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IResource resource = null;
        if (this.workingSet == null) {
            return true;
        }
        if (element instanceof IResource) {
            resource = (IResource)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            resource = (IResource)adaptable.getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = ResourceWorkingSetFilter.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
        }
        if (resource != null) {
            return this.isEnclosed(resource);
        }
        return true;
    }

    private boolean isEnclosed(IResource element) {
        IPath elementPath = element.getFullPath();
        IAdaptable[] workingSetElements = this.cachedWorkingSet;
        if (workingSetElements == null) {
            workingSetElements = this.workingSet.getElements();
        }
        for (int i = 0; i < workingSetElements.length; ++i) {
            IAdaptable workingSetElement = workingSetElements[i];
            IContainmentAdapter containmentAdapter = (IContainmentAdapter)workingSetElement.getAdapter(class$org$eclipse$ui$IContainmentAdapter == null ? ResourceWorkingSetFilter.class$("org.eclipse.ui.IContainmentAdapter") : class$org$eclipse$ui$IContainmentAdapter);
            if (!(containmentAdapter != null ? containmentAdapter.contains((Object)workingSetElement, (Object)element, 15) : this.isEnclosedResource(element, elementPath, workingSetElement))) continue;
            return true;
        }
        return false;
    }

    private boolean isEnclosedResource(IResource element, IPath elementPath, IAdaptable workingSetElement) {
        IResource workingSetResource = null;
        if (workingSetElement.equals(element)) {
            return true;
        }
        workingSetResource = workingSetElement instanceof IResource ? (IResource)workingSetElement : (IResource)workingSetElement.getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = ResourceWorkingSetFilter.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
        if (workingSetResource != null) {
            IPath resourcePath = workingSetResource.getFullPath();
            if (resourcePath.isPrefixOf(elementPath)) {
                return true;
            }
            if (elementPath.isPrefixOf(resourcePath)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        Object[] result = null;
        if (this.workingSet != null) {
            this.cachedWorkingSet = this.workingSet.getElements();
        }
        try {
            result = super.filter(viewer, parent, elements);
        }
        finally {
            this.cachedWorkingSet = null;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

