/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.actions.BuildSetAction;

public class SelectBuildWorkingSetAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow window;
    private IActionBarConfigurer actionBars;

    public SelectBuildWorkingSetAction(IWorkbenchWindow window, IActionBarConfigurer actionBars) {
        super(IDEWorkbenchMessages.getString("SelectWorkingSetAction.text"));
        this.window = window;
        this.actionBars = actionBars;
    }

    private IWorkingSet queryForWorkingSet() {
        IWorkingSetManager manager = this.window.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dialog = manager.createWorkingSetSelectionDialog(this.window.getShell(), false);
        dialog.open();
        IWorkingSet[] sets = dialog.getSelection();
        if (sets == null || sets.length == 0) {
            return null;
        }
        return sets[0];
    }

    public void run() {
        IWorkingSet set = this.queryForWorkingSet();
        if (set != null) {
            new BuildSetAction(set, this.window, this.actionBars).run();
        }
    }

    public void dispose() {
    }

    public void setActionBars(IActionBarConfigurer actionBars) {
        this.actionBars = actionBars;
    }
}

