/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor.items;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import vlcskineditor.Item;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Resource;
import vlcskineditor.Skin;
import vlcskineditor.XML;
import vlcskineditor.history.ItemAddEvent;
import vlcskineditor.history.TextEditEvent;

public class Text
extends Item
implements ActionListener {
    public final String TEXT_DEFAULT = "";
    public final String COLOR_DEFAULT = "#000000";
    public final int WIDTH_DEFAULT = 0;
    public final String ALIGNMENT_DEFAULT = "left";
    public final String SCROLLING_DEFAULT = "auto";
    public String font;
    public String text = "";
    public String color = "#000000";
    public int width = 0;
    public String alignment = "left";
    public String scrolling = "auto";
    JFrame frame = null;
    JTextField id_tf;
    JTextField x_tf;
    JTextField y_tf;
    JTextField help_tf;
    JTextField visible_tf;
    JTextField text_tf;
    JTextField font_tf;
    JTextField color_tf;
    JTextField width_tf;
    JComboBox lefttop_cb;
    JComboBox rightbottom_cb;
    JComboBox xkeepratio_cb;
    JComboBox ykeepratio_cb;
    JComboBox alignment_cb;
    JComboBox scrolling_cb;
    JButton visible_btn;
    JButton color_btn;
    JButton ok_btn;
    JButton cancel_btn;
    JButton help_btn;

    public Text(String string, Skin skin) {
        this.type = "Text";
        this.s = skin;
        this.font = XML.getValue(string, "font");
        if (string.indexOf(" text=\"") != -1) {
            this.text = XML.getValue(string, "text");
        }
        if (string.indexOf(" alignment=\"") != -1) {
            this.alignment = XML.getValue(string, "alignment");
        }
        if (string.indexOf(" scrolling=\"") != -1) {
            this.scrolling = XML.getValue(string, "scrolling");
        }
        if (string.indexOf(" color=\"") != -1) {
            this.color = XML.getValue(string, "color");
        }
        if (string.indexOf(" x=\"") != -1) {
            this.x = XML.getIntValue(string, "x");
        }
        if (string.indexOf(" y=\"") != -1) {
            this.y = XML.getIntValue(string, "y");
        }
        if (string.indexOf(" width=\"") != -1) {
            this.width = XML.getIntValue(string, "width");
        }
        this.id = string.indexOf(" id=\"") != -1 ? XML.getValue(string, "id") : "Unnamed text #" + this.s.getNewId();
        if (string.indexOf(" lefttop=\"") != -1) {
            this.lefttop = XML.getValue(string, "lefttop");
        }
        if (string.indexOf(" rightbottom=\"") != -1) {
            this.rightbottom = XML.getValue(string, "rightbottom");
        }
        if (string.indexOf(" xkeepratio=\"") != -1) {
            this.xkeepratio = XML.getBoolValue(string, "xkeepratio");
        }
        if (string.indexOf(" ykeepratio=\"") != -1) {
            this.ykeepratio = XML.getBoolValue(string, "ykeepratio");
        }
        if (string.indexOf(" visible=\"") != -1) {
            this.visible = XML.getValue(string, "visible");
        }
        this.created = true;
    }

    public Text(Skin skin) {
        this.type = "Text";
        this.s = skin;
        this.font = "defaultfont";
        this.id = "Unnamed text #" + this.s.getNewId();
        this.showOptions();
    }

    @Override
    public void update() {
        if (!this.created) {
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.text = this.text_tf.getText();
            this.font = this.font_tf.getText();
            this.color = this.color_tf.getText();
            this.width = Integer.parseInt(this.width_tf.getText());
            this.alignment = this.alignment_cb.getSelectedItem().toString();
            this.scrolling = this.scrolling_cb.getSelectedItem().toString();
            this.s.updateItems();
            this.s.expandItem(this.id);
            this.frame.setDefaultCloseOperation(1);
            this.created = true;
            ItemAddEvent itemAddEvent = new ItemAddEvent(this.s.getParentListOf(this.id), this);
            this.s.m.hist.addEvent(itemAddEvent);
        } else {
            TextEditEvent textEditEvent = new TextEditEvent(this);
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.text = this.text_tf.getText();
            this.font = this.font_tf.getText();
            this.color = this.color_tf.getText();
            this.width = Integer.parseInt(this.width_tf.getText());
            this.alignment = this.alignment_cb.getSelectedItem().toString();
            this.scrolling = this.scrolling_cb.getSelectedItem().toString();
            this.s.updateItems();
            this.s.expandItem(this.id);
            textEditEvent.setNew();
            this.s.m.hist.addEvent(textEditEvent);
        }
    }

    @Override
    public void showOptions() {
        if (this.frame == null) {
            this.frame = new JFrame("Text settings");
            this.frame.setResizable(false);
            this.frame.setLayout(new FlowLayout());
            if (!this.created) {
                this.frame.setDefaultCloseOperation(0);
            }
            JLabel jLabel = new JLabel("ID*:");
            this.id_tf = new JTextField();
            JLabel jLabel2 = new JLabel("X:");
            this.x_tf = new JTextField();
            this.x_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel3 = new JLabel("Y:");
            this.y_tf = new JTextField();
            this.y_tf.setDocument(new NumbersOnlyDocument());
            String[] stringArray = new String[]{"lefttop", "leftbottom", "righttop", "rightbottom"};
            JLabel jLabel4 = new JLabel("Lefttop:");
            this.lefttop_cb = new JComboBox<String>(stringArray);
            this.lefttop_cb.setToolTipText("Indicate to which corner of the Layout the top-left-hand corner of this item is attached, in case of resizing.");
            JLabel jLabel5 = new JLabel("Rightbottom:");
            this.rightbottom_cb = new JComboBox<String>(stringArray);
            this.rightbottom_cb.setToolTipText("Indicate to which corner of the Layout the bottom-right-hand corner of this item is attached, in case of resizing.");
            Object[] objectArray = new Object[]{true, false};
            JLabel jLabel6 = new JLabel("Keep X Ratio:");
            this.xkeepratio_cb = new JComboBox<Object>(objectArray);
            this.xkeepratio_cb.setToolTipText("When set to true, the behaviour of the horizontal resizing is changed. For example, if initially the space to the left of the control is twice as big as the one to its right, this will stay the same during any horizontal resizing. The width of the control stays constant.");
            JLabel jLabel7 = new JLabel("Keep Y Ratio:");
            this.ykeepratio_cb = new JComboBox<Object>(objectArray);
            this.ykeepratio_cb.setToolTipText("When set to true, the behaviour of the vertical resizing is changed. For example, if initially the space to the top of the control is twice as big as the one to its bottom, this will stay the same during any vertical resizing. The height of the control stays constant.");
            JLabel jLabel8 = new JLabel("Visibility:");
            this.visible_tf = new JTextField();
            this.visible_btn = new JButton("", this.s.m.help_icon);
            this.visible_btn.addActionListener(this);
            JLabel jLabel9 = new JLabel("Help Text:");
            this.help_tf = new JTextField();
            this.help_tf.setToolTipText("Help text for the current control. The variable '$H' will be expanded to this value when the mouse hovers the current control.");
            JLabel jLabel10 = new JLabel("Text:");
            this.text_tf = new JTextField();
            JLabel jLabel11 = new JLabel("Font:");
            this.font_tf = new JTextField();
            JLabel jLabel12 = new JLabel("Color:");
            this.color_tf = new JTextField();
            this.color_btn = new JButton("Choose...");
            this.color_btn.addActionListener(this);
            JLabel jLabel13 = new JLabel("Width:");
            this.width_tf = new JTextField();
            this.width_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel14 = new JLabel("Alignment:");
            String[] stringArray2 = new String[]{"left", "center", "right"};
            this.alignment_cb = new JComboBox<String>(stringArray2);
            JLabel jLabel15 = new JLabel("Scrolling:");
            String[] stringArray3 = new String[]{"none", "auto", "manual"};
            this.scrolling_cb = new JComboBox<String>(stringArray3);
            this.ok_btn = new JButton("OK");
            this.ok_btn.addActionListener(this);
            this.ok_btn.setPreferredSize(new Dimension(70, 25));
            this.cancel_btn = new JButton("Cancel");
            this.cancel_btn.addActionListener(this);
            this.cancel_btn.setPreferredSize(new Dimension(70, 25));
            this.help_btn = new JButton("Help");
            this.help_btn.addActionListener(this);
            this.help_btn.setPreferredSize(new Dimension(70, 25));
            JPanel jPanel = new JPanel(null);
            jPanel.add(jLabel);
            jPanel.add(this.id_tf);
            jLabel.setBounds(5, 15, 75, 24);
            this.id_tf.setBounds(85, 15, 150, 24);
            jPanel.add(jLabel2);
            jPanel.add(this.x_tf);
            jLabel2.setBounds(5, 45, 75, 24);
            this.x_tf.setBounds(85, 45, 150, 24);
            jPanel.add(jLabel3);
            jPanel.add(this.y_tf);
            jLabel3.setBounds(5, 75, 75, 24);
            this.y_tf.setBounds(85, 75, 150, 24);
            jPanel.add(jLabel4);
            jPanel.add(this.lefttop_cb);
            jLabel4.setBounds(5, 105, 75, 24);
            this.lefttop_cb.setBounds(85, 105, 150, 24);
            jPanel.add(jLabel5);
            jPanel.add(this.rightbottom_cb);
            jLabel5.setBounds(5, 135, 75, 24);
            this.rightbottom_cb.setBounds(85, 135, 150, 24);
            jPanel.add(jLabel6);
            jPanel.add(this.xkeepratio_cb);
            jLabel6.setBounds(5, 165, 75, 24);
            this.xkeepratio_cb.setBounds(85, 165, 150, 24);
            jPanel.add(jLabel7);
            jPanel.add(this.ykeepratio_cb);
            jLabel7.setBounds(5, 195, 75, 24);
            this.ykeepratio_cb.setBounds(85, 195, 150, 24);
            jPanel.add(jLabel8);
            jPanel.add(this.visible_tf);
            jPanel.add(this.visible_btn);
            jLabel8.setBounds(5, 225, 75, 24);
            this.visible_tf.setBounds(85, 225, 120, 24);
            this.visible_btn.setBounds(210, 225, 24, 24);
            jPanel.add(jLabel9);
            jPanel.add(this.help_tf);
            jLabel9.setBounds(5, 255, 75, 24);
            this.help_tf.setBounds(85, 255, 150, 24);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "General Attributes"));
            jPanel.setMinimumSize(new Dimension(240, 285));
            jPanel.setPreferredSize(new Dimension(240, 285));
            jPanel.setMaximumSize(new Dimension(240, 285));
            this.frame.add(jPanel);
            JPanel jPanel2 = new JPanel(null);
            jPanel2.add(jLabel10);
            jPanel2.add(this.text_tf);
            jLabel10.setBounds(5, 15, 75, 24);
            this.text_tf.setBounds(85, 15, 150, 24);
            jPanel2.add(jLabel11);
            jPanel2.add(this.font_tf);
            jLabel11.setBounds(5, 45, 75, 24);
            this.font_tf.setBounds(85, 45, 150, 24);
            jPanel2.add(jLabel12);
            jPanel2.add(this.color_tf);
            jPanel2.add(this.color_btn);
            jLabel12.setBounds(5, 75, 75, 24);
            this.color_tf.setBounds(85, 75, 50, 24);
            this.color_btn.setBounds(140, 75, 95, 24);
            jPanel2.add(jLabel13);
            jPanel2.add(this.width_tf);
            jLabel13.setBounds(5, 105, 75, 24);
            this.width_tf.setBounds(85, 105, 150, 24);
            jPanel2.add(jLabel14);
            jPanel2.add(this.alignment_cb);
            jLabel14.setBounds(5, 135, 75, 24);
            this.alignment_cb.setBounds(85, 135, 150, 24);
            jPanel2.add(jLabel15);
            jPanel2.add(this.scrolling_cb);
            jLabel15.setBounds(5, 165, 75, 24);
            this.scrolling_cb.setBounds(85, 165, 150, 24);
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Text Attributes"));
            jPanel2.setMinimumSize(new Dimension(240, 195));
            jPanel2.setPreferredSize(new Dimension(240, 195));
            jPanel2.setMaximumSize(new Dimension(240, 195));
            this.frame.add(jPanel2);
            this.frame.add(this.ok_btn);
            this.frame.add(this.cancel_btn);
            this.frame.add(this.help_btn);
            this.frame.add(new JLabel("* required attribute"));
            this.frame.setMinimumSize(new Dimension(250, 550));
            this.frame.setPreferredSize(new Dimension(250, 550));
            this.frame.setMaximumSize(new Dimension(250, 550));
            this.frame.pack();
            this.frame.getRootPane().setDefaultButton(this.ok_btn);
        }
        this.id_tf.setText(this.id);
        this.x_tf.setText(String.valueOf(this.x));
        this.y_tf.setText(String.valueOf(this.y));
        this.lefttop_cb.setSelectedItem(this.lefttop);
        this.rightbottom_cb.setSelectedItem(this.rightbottom);
        this.xkeepratio_cb.setSelectedItem(this.xkeepratio);
        this.ykeepratio_cb.setSelectedItem(this.ykeepratio);
        this.visible_tf.setText(this.visible);
        this.help_tf.setText(this.help);
        this.text_tf.setText(this.text);
        this.font_tf.setText(this.font);
        this.color_tf.setText(this.color);
        this.width_tf.setText(String.valueOf(this.width));
        this.alignment_cb.setSelectedItem(this.alignment);
        this.scrolling_cb.setSelectedItem(this.scrolling);
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.ok_btn)) {
            if (this.id_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, "Please enter a valid ID!", "ID not valid", 1);
                return;
            }
            if (!this.id_tf.getText().equals(this.id) && this.s.idExists(this.id_tf.getText())) {
                JOptionPane.showMessageDialog(this.frame, "The ID \"" + this.id_tf.getText() + "\" already exists, please choose another one.", "ID not valid", 1);
                return;
            }
            if (!this.font_tf.getText().equals("defaultfont") && this.s.getResource(this.font_tf.getText()) == null) {
                JOptionPane.showMessageDialog(this.frame, "The Font \"" + this.font_tf.getText() + "\" does not exist.", "Font not valid", 1);
                return;
            }
            this.update();
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        } else if (actionEvent.getSource().equals(this.help_btn)) {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI("http://www.videolan.org/vlc/skinedhlp/i-text.html"));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.toString(), exception.getMessage(), 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Could not launch Browser", "Go to the following URL manually:\nhttp://www.videolan.org/vlc/skinedhlp/i-text.html", 2);
            }
        } else if (actionEvent.getSource().equals(this.color_btn)) {
            Color color = JColorChooser.showDialog(this.frame, "Choose text color", Color.decode(this.color_tf.getText()));
            if (color != null) {
                String string = "#";
                if (color.getRed() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getRed()).toUpperCase();
                if (color.getGreen() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getGreen()).toUpperCase();
                if (color.getBlue() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getBlue()).toUpperCase();
                this.color_tf.setText(string);
            }
        } else if (actionEvent.getSource().equals(this.visible_btn)) {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI("http://www.videolan.org/vlc/skinedhlp/boolexpr.html"));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.toString(), exception.getMessage(), 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Could not launch Browser", "Go to the following URL manually:\nhttp://www.videolan.org/vlc/skinedhlp/boolexpr.html", 2);
            }
        } else if (actionEvent.getSource().equals(this.cancel_btn)) {
            List<Item> list;
            if (!this.created && (list = this.s.getParentListOf(this.id)) != null) {
                list.remove(this);
            }
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        }
    }

    @Override
    public String returnCode(String string) {
        String string2 = string + "<Text";
        string2 = string2 + " text=\"" + this.text + "\"";
        string2 = string2 + " font=\"" + this.font + "\"";
        if (!this.alignment.equals("left")) {
            string2 = string2 + " alignment=\"" + this.alignment + "\"";
        }
        if (!this.color.equals("#000000")) {
            string2 = string2 + " color=\"" + this.color + "\"";
        }
        if (!this.id.equals("Unnamed")) {
            string2 = string2 + " id=\"" + this.id + "\"";
        }
        if (this.x != 0) {
            string2 = string2 + " x=\"" + String.valueOf(this.x) + "\"";
        }
        if (this.y != 0) {
            string2 = string2 + " y=\"" + String.valueOf(this.y) + "\"";
        }
        if (this.width != 0) {
            string2 = string2 + " width=\"" + String.valueOf(this.width) + "\"";
        }
        if (!this.lefttop.equals("lefttop")) {
            string2 = string2 + " lefttop=\"" + this.lefttop + "\"";
        }
        if (!this.rightbottom.equals("lefttop")) {
            string2 = string2 + " rightbottom=\"" + this.rightbottom + "\"";
        }
        if (this.xkeepratio) {
            string2 = string2 + " xkeepratio=\"" + String.valueOf(this.xkeepratio) + "\"";
        }
        if (this.ykeepratio) {
            string2 = string2 + " ykeepratio=\"" + String.valueOf(this.ykeepratio) + "\"";
        }
        if (!this.help.equals("")) {
            string2 = string2 + " help=\"" + this.help + "\"";
        }
        if (!this.visible.equals("true")) {
            string2 = string2 + " visible=\"" + this.visible + "\"";
        }
        string2 = string2 + "/>";
        return string2;
    }

    @Override
    public void draw(Graphics2D graphics2D, int n) {
        this.draw(graphics2D, 0, 0, n);
    }

    @Override
    public void draw(Graphics2D graphics2D, int n, int n2, int n3) {
        Object object;
        Object object2;
        if (!this.created || this.font == null) {
            return;
        }
        Font font = this.s.getFont(this.font);
        if (font == null) {
            object2 = this.s.getResource(this.font);
            if (((Resource)object2).type.equals("Font")) {
                object = (vlcskineditor.resources.Font)object2;
                font = new Font("SansSerif", 0, ((vlcskineditor.resources.Font)object).size);
            } else {
                font = new Font("SansSerif", 0, 12);
            }
        }
        if (this.s.gvars.parseBoolean(this.visible)) {
            object = this.s.gvars.parseString(this.text);
            object2 = this.width == 0 ? new BufferedImage((int)graphics2D.getFontMetrics().getStringBounds((String)object, graphics2D).getWidth(), graphics2D.getFontMetrics().getHeight(), 2) : new BufferedImage(this.width, graphics2D.getFontMetrics().getHeight(), 2);
            Graphics2D graphics2D2 = ((BufferedImage)object2).createGraphics();
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D2.setFont(font);
            graphics2D2.setColor(Color.decode(this.color));
            if (this.width != 0 && this.alignment.equals("right")) {
                graphics2D2.drawString((String)object, (int)((double)this.width - graphics2D2.getFontMetrics().getStringBounds((String)object, graphics2D).getWidth()), 0 + graphics2D2.getFontMetrics().getAscent());
            } else if (this.width != 0 && this.alignment.equals("center")) {
                graphics2D2.drawString((String)object, (int)(((double)this.width - graphics2D2.getFontMetrics().getStringBounds((String)object, graphics2D).getWidth()) / 2.0), 0 + graphics2D2.getFontMetrics().getAscent());
            } else {
                graphics2D2.drawString((String)object, 0, 0 + graphics2D2.getFontMetrics().getAscent());
            }
            graphics2D.drawImage((Image)object2, (this.x + n) * n3, (this.y + n2) * n3, ((BufferedImage)object2).getWidth() * n3, ((BufferedImage)object2).getHeight() * n3, null);
        }
        if (this.selected) {
            graphics2D.setColor(Color.RED);
            graphics2D.drawRect((this.x + n) * n3, (this.y + n2) * n3, this.width * n3, font.getSize() * n3);
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        Font font = this.s.getFont(this.font);
        return n >= this.x + this.offsetx && n <= this.x + this.width + this.offsetx && n2 >= this.y + this.offsety && n2 <= this.y + font.getSize() + this.offsety;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Text: " + this.id);
        return defaultMutableTreeNode;
    }

    @Override
    public boolean uses(String string) {
        return this.font.equals(string);
    }
}

