/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;

public abstract class RrdBackend {
    private String path;
    private static long count;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RrdBackend(String string) {
        this.path = string;
        ++count;
    }

    public String getPath() {
        return this.path;
    }

    protected abstract void write(long var1, byte[] var3) throws IOException;

    protected abstract void read(long var1, byte[] var3) throws IOException;

    public final byte[] readAll() throws IOException {
        byte[] byArray = new byte[(int)this.getLength()];
        this.read(0L, byArray);
        return byArray;
    }

    public abstract long getLength() throws IOException;

    protected abstract void setLength(long var1) throws IOException;

    public void close() throws IOException {
        this.sync();
    }

    protected void beforeUpdate() throws IOException {
    }

    protected void afterUpdate() throws IOException {
    }

    protected void beforeFetch() throws IOException {
    }

    protected void afterFetch() throws IOException {
    }

    protected void afterCreate() throws IOException {
    }

    public void sync() throws IOException {
    }

    final void writeInt(long l, int n) throws IOException {
        this.write(l, RrdBackend.getIntBytes(n));
    }

    final void writeLong(long l, long l2) throws IOException {
        this.write(l, RrdBackend.getLongBytes(l2));
    }

    final void writeDouble(long l, double d) throws IOException {
        this.write(l, RrdBackend.getDoubleBytes(d));
    }

    final void writeDouble(long l, double d, int n) throws IOException {
        byte[] byArray = RrdBackend.getDoubleBytes(d);
        byte[] byArray2 = new byte[8 * n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byArray2[n2++] = byArray[0];
            byArray2[n2++] = byArray[1];
            byArray2[n2++] = byArray[2];
            byArray2[n2++] = byArray[3];
            byArray2[n2++] = byArray[4];
            byArray2[n2++] = byArray[5];
            byArray2[n2++] = byArray[6];
            byArray2[n2++] = byArray[7];
        }
        this.write(l, byArray2);
        byArray2 = null;
    }

    final void writeDouble(long l, double[] dArray) throws IOException {
        int n = dArray.length;
        byte[] byArray = new byte[8 * n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte[] byArray2 = RrdBackend.getDoubleBytes(dArray[i]);
            byArray[n2++] = byArray2[0];
            byArray[n2++] = byArray2[1];
            byArray[n2++] = byArray2[2];
            byArray[n2++] = byArray2[3];
            byArray[n2++] = byArray2[4];
            byArray[n2++] = byArray2[5];
            byArray[n2++] = byArray2[6];
            byArray[n2++] = byArray2[7];
        }
        this.write(l, byArray);
        byArray = null;
    }

    final void writeString(long l, String string) throws IOException {
        string = string.trim();
        byte[] byArray = new byte[40];
        int n = 0;
        for (int i = 0; i < 20; ++i) {
            char c = i < string.length() ? (char)string.charAt(i) : (char)' ';
            byte[] byArray2 = RrdBackend.getCharBytes(c);
            byArray[n++] = byArray2[0];
            byArray[n++] = byArray2[1];
        }
        this.write(l, byArray);
    }

    final int readInt(long l) throws IOException {
        byte[] byArray = new byte[4];
        this.read(l, byArray);
        return RrdBackend.getInt(byArray);
    }

    final long readLong(long l) throws IOException {
        byte[] byArray = new byte[8];
        this.read(l, byArray);
        return RrdBackend.getLong(byArray);
    }

    final double readDouble(long l) throws IOException {
        byte[] byArray = new byte[8];
        this.read(l, byArray);
        return RrdBackend.getDouble(byArray);
    }

    final double[] readDouble(long l, int n) throws IOException {
        int n2 = 8 * n;
        byte[] byArray = new byte[n2];
        this.read(l, byArray);
        double[] dArray = new double[n];
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            byte[] byArray2 = new byte[]{byArray[++n3], byArray[++n3], byArray[++n3], byArray[++n3], byArray[++n3], byArray[++n3], byArray[++n3], byArray[++n3]};
            dArray[i] = RrdBackend.getDouble(byArray2);
        }
        byArray = null;
        return dArray;
    }

    final String readString(long l) throws IOException {
        byte[] byArray = new byte[40];
        char[] cArray = new char[20];
        this.read(l, byArray);
        int n = -1;
        for (int i = 0; i < 20; ++i) {
            byte[] byArray2 = new byte[]{byArray[++n], byArray[++n]};
            cArray[i] = RrdBackend.getChar(byArray2);
        }
        return new String(cArray).trim();
    }

    private static final byte[] getIntBytes(int n) {
        byte[] byArray = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n >>> 0 & 0xFF)};
        return byArray;
    }

    private static final byte[] getLongBytes(long l) {
        byte[] byArray = new byte[]{(byte)((int)(l >>> 56) & 0xFF), (byte)((int)(l >>> 48) & 0xFF), (byte)((int)(l >>> 40) & 0xFF), (byte)((int)(l >>> 32) & 0xFF), (byte)((int)(l >>> 24) & 0xFF), (byte)((int)(l >>> 16) & 0xFF), (byte)((int)(l >>> 8) & 0xFF), (byte)((int)(l >>> 0) & 0xFF)};
        return byArray;
    }

    private static final byte[] getCharBytes(char c) {
        byte[] byArray = new byte[]{(byte)(c >>> 8 & 0xFF), (byte)(c >>> 0 & 0xFF)};
        return byArray;
    }

    private static final byte[] getDoubleBytes(double d) {
        byte[] byArray = RrdBackend.getLongBytes(Double.doubleToLongBits(d));
        return byArray;
    }

    private static final int getInt(byte[] byArray) {
        if (!$assertionsDisabled && byArray.length != 4) {
            throw new AssertionError((Object)"Invalid number of bytes for integer conversion");
        }
        return (byArray[0] << 24 & 0xFF000000) + (byArray[1] << 16 & 0xFF0000) + (byArray[2] << 8 & 0xFF00) + (byArray[3] << 0 & 0xFF);
    }

    private static final long getLong(byte[] byArray) {
        if (!$assertionsDisabled && byArray.length != 8) {
            throw new AssertionError((Object)"Invalid number of bytes for long conversion");
        }
        int n = RrdBackend.getInt(new byte[]{byArray[0], byArray[1], byArray[2], byArray[3]});
        int n2 = RrdBackend.getInt(new byte[]{byArray[4], byArray[5], byArray[6], byArray[7]});
        long l = ((long)n << 32) + ((long)n2 & 0xFFFFFFFFL);
        return l;
    }

    private static final char getChar(byte[] byArray) {
        if (!$assertionsDisabled && byArray.length != 2) {
            throw new AssertionError((Object)"Invalid number of bytes for char conversion");
        }
        return (char)((byArray[0] << 8 & 0xFF00) + (byArray[1] << 0 & 0xFF));
    }

    private static final double getDouble(byte[] byArray) {
        if (!$assertionsDisabled && byArray.length != 8) {
            throw new AssertionError((Object)"Invalid number of bytes for double conversion");
        }
        return Double.longBitsToDouble(RrdBackend.getLong(byArray));
    }

    static long getCount() {
        return count;
    }

    static {
        $assertionsDisabled = !RrdBackend.class.desiredAssertionStatus();
        count = 0L;
    }
}

