/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.util.HashMap;
import org.jrobin.core.RrdException;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.ChartGraphics;
import org.jrobin.graph.Line;
import org.jrobin.graph.Source;

class CustomLine
extends Line {
    private long xVal1;
    private long xVal2;
    private double yVal1;
    private double yVal2;
    private double dc;

    CustomLine(long l, double d, long l2, double d2, Color color) {
        this.color = color;
        if (color == null) {
            this.visible = false;
        }
        this.xVal1 = l;
        this.xVal2 = l2;
        this.yVal1 = d;
        this.yVal2 = d2;
        try {
            long l3 = this.xVal2 - this.xVal1;
            this.dc = l3 != 0L ? (this.yVal2 - this.yVal1) / (double)l3 : 0.0;
        }
        catch (Exception exception) {
            this.dc = 0.0;
        }
    }

    CustomLine(long l, double d, long l2, double d2, Color color, int n) {
        this(l, d, l2, d2, color);
        this.lineWidth = n;
    }

    void draw(ChartGraphics chartGraphics, int[] nArray, double[] dArray, int n) throws RrdException {
        int n2;
        chartGraphics.setColor(this.color);
        chartGraphics.setStroke(this.lineWidth != 1 ? new BasicStroke(this.lineWidth) : DEF_LINE_STROKE);
        int n3 = this.xVal1 == Long.MIN_VALUE ? chartGraphics.getMinX() : (this.xVal1 == Long.MAX_VALUE ? chartGraphics.getMaxX() : chartGraphics.getX(this.xVal1));
        int n4 = this.xVal2 == Long.MIN_VALUE ? chartGraphics.getMinX() : (this.xVal2 == Long.MAX_VALUE ? chartGraphics.getMaxX() : chartGraphics.getX(this.xVal2));
        int n5 = this.yVal1 == Double.MIN_VALUE ? chartGraphics.getMinY() : (this.yVal1 == Double.MAX_VALUE ? chartGraphics.getMaxY() : chartGraphics.getY(this.yVal1));
        int n6 = this.yVal2 == Double.MIN_VALUE ? chartGraphics.getMinY() : (this.yVal2 == Double.MAX_VALUE ? chartGraphics.getMaxY() : chartGraphics.getY(this.yVal2));
        if (this.visible) {
            chartGraphics.drawLine(n3, n5, n4, n6);
        }
        if ((n2 = n4 - n3) != 0) {
            double d = (double)(n6 - n5) * 1.0 / (double)n2;
            for (int i = 0; i < nArray.length; ++i) {
                dArray[i] = nArray[i] < n3 || nArray[i] > n4 ? chartGraphics.getInverseY(0) : (n5 == n6 ? chartGraphics.getInverseY(n5) : chartGraphics.getInverseY((int)(d * (double)(nArray[i] - n3) + (double)n5)));
            }
        }
        chartGraphics.setStroke(STROKE);
    }

    double getValue(int n, long[] lArray) {
        long l = lArray[n];
        if (l > this.xVal2 || l < this.xVal1) {
            return Double.NaN;
        }
        if (this.yVal1 == this.yVal2) {
            return this.yVal1;
        }
        if (this.yVal1 == Double.MIN_VALUE && this.yVal2 == Double.MAX_VALUE) {
            return Double.NaN;
        }
        if (this.xVal1 == this.xVal2) {
            return Double.NaN;
        }
        return this.dc * (double)(l - this.xVal1) + this.yVal1;
    }

    void setSource(Source[] sourceArray, HashMap hashMap) throws RrdException {
    }

    void setValue(int n, long l, long[] lArray) {
    }

    void exportXmlTemplate(XmlWriter xmlWriter, String string) {
        if (this.yVal1 == this.yVal2 && this.xVal1 != this.xVal2) {
            xmlWriter.startTag("hrule");
            xmlWriter.writeTag("value", this.yVal1);
            xmlWriter.writeTag("color", this.color);
            xmlWriter.writeTag("legend", string);
            xmlWriter.writeTag("width", this.lineWidth);
            xmlWriter.closeTag();
        } else if (this.yVal1 != this.yVal2 && this.xVal1 == this.xVal2) {
            xmlWriter.startTag("vrule");
            xmlWriter.writeTag("time", this.xVal1);
            xmlWriter.writeTag("color", this.color);
            xmlWriter.writeTag("legend", string);
            xmlWriter.writeTag("width", this.lineWidth);
            xmlWriter.closeTag();
        } else if (this.yVal1 != this.yVal2 && this.xVal1 != this.xVal2) {
            xmlWriter.startTag("line");
            xmlWriter.writeTag("time1", this.xVal1);
            xmlWriter.writeTag("value1", this.yVal1);
            xmlWriter.writeTag("time2", this.xVal2);
            xmlWriter.writeTag("value2", this.yVal2);
            xmlWriter.writeTag("color", this.color);
            xmlWriter.writeTag("legend", string);
            xmlWriter.writeTag("width", this.lineWidth);
            xmlWriter.closeTag();
        }
    }
}

