/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.Comment;

public class TimeText
extends Comment {
    private static final String TIME_MARKER = "@t";
    private Date textDate = null;
    private DateFormat dateFormat;
    private ArrayList parsedList;

    TimeText(String string, String string2) throws RrdException {
        this(string, new SimpleDateFormat(string2));
    }

    TimeText(String string, DateFormat dateFormat) throws RrdException {
        super(string);
        this.dateFormat = dateFormat;
        if (string.indexOf(TIME_MARKER) < 0) {
            throw new RrdException("Could not find where to place timestamp. No @t placeholder found.");
        }
    }

    TimeText(String string, String string2, long l) throws RrdException {
        this(string, (DateFormat)new SimpleDateFormat(string2), new Date(l * 1000L));
    }

    TimeText(String string, DateFormat dateFormat, long l) throws RrdException {
        this(string, dateFormat, new Date(l * 1000L));
    }

    TimeText(String string, String string2, Date date) throws RrdException {
        this(string, (DateFormat)new SimpleDateFormat(string2), date);
    }

    TimeText(String string, DateFormat dateFormat, Date date) throws RrdException {
        super(string);
        this.textDate = date;
        this.dateFormat = dateFormat;
        if (string.indexOf(TIME_MARKER) < 0) {
            throw new RrdException("Could not find where to place timestamp. No @t placeholder found.");
        }
    }

    TimeText(String string, String string2, Calendar calendar) throws RrdException {
        this(string, (DateFormat)new SimpleDateFormat(string2), calendar.getTime());
    }

    TimeText(String string, DateFormat dateFormat, Calendar calendar) throws RrdException {
        this(string, dateFormat, calendar.getTime());
    }

    ArrayList getTokens() {
        this.parsedList = new ArrayList(this.oList);
        String string = this.dateFormat.format(this.textDate != null ? this.textDate : new Date());
        for (int i = 0; i < this.oList.size(); i += 2) {
            String string2 = (String)this.oList.get(i);
            string2 = string2.replaceAll(TIME_MARKER, string);
            this.parsedList.set(i, string2);
        }
        return this.parsedList;
    }

    void exportXmlTemplate(XmlWriter xmlWriter) {
        xmlWriter.startTag("time");
        xmlWriter.writeTag("format", this.text);
        if (this.dateFormat instanceof SimpleDateFormat) {
            xmlWriter.writeTag("pattern", ((SimpleDateFormat)this.dateFormat).toPattern());
        } else {
            xmlWriter.writeTag("pattern", "");
        }
        if (this.textDate != null) {
            xmlWriter.writeTag("value", Util.getTimestamp(this.textDate));
        }
        xmlWriter.closeTag();
    }
}

