/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.metadata.TableMetaDataProvider;
import org.springframework.jdbc.core.metadata.TableMetaDataProviderFactory;
import org.springframework.jdbc.core.metadata.TableParameterMetaData;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableMetaDataContext {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String tableName;
    private String catalogName;
    private String schemaName;
    private List<String> tableColumns = new ArrayList<String>();
    private boolean accessTableParameterMetaData = true;
    private TableMetaDataProvider metaDataProvider;
    private boolean generatedKeyColumnsUsed = false;

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setAccessTableParameterMetaData(boolean accessTableParameterMetaData) {
        this.accessTableParameterMetaData = accessTableParameterMetaData;
    }

    public boolean isAccessTableParameterMetaData() {
        return this.accessTableParameterMetaData;
    }

    public List<String> getTableColumns() {
        return this.tableColumns;
    }

    public boolean isGetGeneratedKeysSupported() {
        return this.metaDataProvider.isGetGeneratedKeysSupported();
    }

    public boolean isGetGeneratedKeysSimulated() {
        return this.metaDataProvider.isGetGeneratedKeysSimulated();
    }

    public String getSimulationQueryForGetGeneratedKey(String tableName, String keyColumnName) {
        return this.metaDataProvider.getSimpleQueryForGetGeneratedKey(tableName, keyColumnName);
    }

    public boolean isGeneratedKeysColumnNameArraySupported() {
        return this.metaDataProvider.isGeneratedKeysColumnNameArraySupported();
    }

    public void processMetaData(DataSource dataSource, List<String> declaredColumns, String[] generatedKeyNames) {
        this.metaDataProvider = TableMetaDataProviderFactory.createMetaDataProvider(dataSource, this);
        this.tableColumns = this.reconcileColumnsToUse(declaredColumns, generatedKeyNames);
    }

    private List<String> reconcileColumnsToUse(List<String> declaredColumns, String[] generatedKeyNames) {
        if (generatedKeyNames.length > 0) {
            this.generatedKeyColumnsUsed = true;
        }
        if (declaredColumns.size() > 0) {
            return new ArrayList<String>(declaredColumns);
        }
        HashSet<String> keys = new HashSet<String>(generatedKeyNames.length);
        for (String key : generatedKeyNames) {
            keys.add(key.toUpperCase());
        }
        ArrayList<String> columns = new ArrayList<String>();
        for (TableParameterMetaData meta : this.metaDataProvider.getTableParameterMetaData()) {
            if (keys.contains(meta.getParameterName().toUpperCase())) continue;
            columns.add(meta.getParameterName());
        }
        return columns;
    }

    public List<Object> matchInParameterValuesWithInsertColumns(SqlParameterSource parameterSource) {
        ArrayList<Object> values = new ArrayList<Object>();
        Map caseInsensitiveParameterNames = SqlParameterSourceUtils.extractCaseInsensitiveParameterNames(parameterSource);
        for (String column : this.tableColumns) {
            if (parameterSource.hasValue(column)) {
                values.add(SqlParameterSourceUtils.getTypedValue(parameterSource, column));
                continue;
            }
            String lowerCaseName = column.toLowerCase();
            if (parameterSource.hasValue(lowerCaseName)) {
                values.add(SqlParameterSourceUtils.getTypedValue(parameterSource, lowerCaseName));
                continue;
            }
            String propertyName = JdbcUtils.convertUnderscoreNameToPropertyName(column);
            if (parameterSource.hasValue(propertyName)) {
                values.add(SqlParameterSourceUtils.getTypedValue(parameterSource, propertyName));
                continue;
            }
            if (caseInsensitiveParameterNames.containsKey(lowerCaseName)) {
                values.add(SqlParameterSourceUtils.getTypedValue(parameterSource, (String)caseInsensitiveParameterNames.get(lowerCaseName)));
                continue;
            }
            values.add(null);
        }
        return values;
    }

    public List<Object> matchInParameterValuesWithInsertColumns(Map<String, Object> inParameters) {
        ArrayList<Object> values = new ArrayList<Object>();
        HashMap<String, Object> source = new HashMap<String, Object>();
        for (String key : inParameters.keySet()) {
            source.put(key.toLowerCase(), inParameters.get(key));
        }
        for (String column : this.tableColumns) {
            values.add(source.get(column.toLowerCase()));
        }
        return values;
    }

    public String createInsertString(String[] generatedKeyNames) {
        HashSet<String> keys = new HashSet<String>(generatedKeyNames.length);
        for (String key : generatedKeyNames) {
            keys.add(key.toUpperCase());
        }
        StringBuilder insertStatement = new StringBuilder();
        insertStatement.append("INSERT INTO ");
        if (this.getSchemaName() != null) {
            insertStatement.append(this.getSchemaName());
            insertStatement.append(".");
        }
        insertStatement.append(this.getTableName());
        insertStatement.append(" (");
        int columnCount = 0;
        for (String columnName : this.getTableColumns()) {
            if (keys.contains(columnName.toUpperCase())) continue;
            if (++columnCount > 1) {
                insertStatement.append(", ");
            }
            insertStatement.append(columnName);
        }
        insertStatement.append(") VALUES(");
        if (columnCount < 1) {
            if (this.generatedKeyColumnsUsed) {
                this.logger.info((Object)("Unable to locate non-key columns for table '" + this.getTableName() + "' so an empty insert statement is generated"));
            } else {
                throw new InvalidDataAccessApiUsageException("Unable to locate columns for table '" + this.getTableName() + "' so an insert statement can't be generated");
            }
        }
        for (int i = 0; i < columnCount; ++i) {
            if (i > 0) {
                insertStatement.append(", ");
            }
            insertStatement.append("?");
        }
        insertStatement.append(")");
        return insertStatement.toString();
    }

    public int[] createInsertTypes() {
        int[] types = new int[this.getTableColumns().size()];
        List<TableParameterMetaData> parameters = this.metaDataProvider.getTableParameterMetaData();
        HashMap<String, TableParameterMetaData> parameterMap = new HashMap<String, TableParameterMetaData>(parameters.size());
        for (TableParameterMetaData tpmd : parameters) {
            parameterMap.put(tpmd.getParameterName().toUpperCase(), tpmd);
        }
        int typeIndx = 0;
        for (String column : this.getTableColumns()) {
            TableParameterMetaData tpmd;
            types[typeIndx] = column == null ? Integer.MIN_VALUE : ((tpmd = (TableParameterMetaData)parameterMap.get(column.toUpperCase())) != null ? tpmd.getSqlType() : Integer.MIN_VALUE);
            ++typeIndx;
        }
        return types;
    }
}

