/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 *
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.order;

import java.io.IOException;

import org.videolan.vlma.model.Media;
import org.videolan.vlma.model.Order;
import org.videolan.vlma.model.StreamChannel;
import org.videolan.vlma.model.StreamingStrategy;

public class StreamOrderSender extends OrderSender {

    @Override
    public void start(Order o) throws IOException {
        telnetConnect(o.getAdapter().getServer());
        for (Media m : o.getMedias()) {
            StreamChannel ch = (StreamChannel) m;

            String commandName = getVLMCommandName(o) + ch.getId();

            init(commandName, o.getAdapter());
            telnetCommand("setup " + commandName + " loop", o.getAdapter());
            telnetCommand("setup " + commandName + " option sout-keep", o.getAdapter());
            telnetCommand("setup " + commandName + " input \"" + ch.getStreamURL()
                    + "\"", o.getAdapter());

            StringBuilder output = new StringBuilder();
            output.append(String.format("#standard{mux=%s,access=%s,dst=%s", getMux(ch.getProgram()),getAccess(ch.getProgram()), getDst(ch.getProgram())));
            if (ch.getProgram().getStreamingStrategy().isEnabled(StreamingStrategy.Announcement.SAP)) {
                output.append(String.format(",sap,name=\"%s\",group=\"%s\")", ch.getProgram().getSapName(), ch.getProgram().getSapGroup()));
            }
            output.append("}");

            telnetCommand("setup " + commandName + " output " + output.toString(), o.getAdapter());
            telnetCommand("setup " + commandName + " enabled", o.getAdapter());
            telnetCommand("control " + commandName + " play", o.getAdapter());
        }
        telnetClose();
    }

    @Override
    public void stop(Order o) throws IOException {
        telnetConnect(o.getAdapter().getServer());
        for (Media m : o.getMedias()) {
            StreamChannel ch = (StreamChannel) m;
            stopCommand(getVLMCommandName(o) + ch.getId(), o.getAdapter());
        }
        telnetClose();
    }
}
